rule win_xiaoba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xiaoba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xiaoba"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7407 a9???????? 7557 8b8644010000 33c9 668b8e48010000 85c9 }
            // n = 7, score = 100
            //   7407                 | je                  9
            //   a9????????           |                     
            //   7557                 | jne                 0x59
            //   8b8644010000         | mov                 eax, dword ptr [esi + 0x144]
            //   33c9                 | xor                 ecx, ecx
            //   668b8e48010000       | mov                 cx, word ptr [esi + 0x148]
            //   85c9                 | test                ecx, ecx

        $sequence_1 = { d9c0 dc642428 dd5c2440 dd442410 dc642420 dd442440 d9c1 }
            // n = 7, score = 100
            //   d9c0                 | fld                 st(0)
            //   dc642428             | fsub                qword ptr [esp + 0x28]
            //   dd5c2440             | fstp                qword ptr [esp + 0x40]
            //   dd442410             | fld                 qword ptr [esp + 0x10]
            //   dc642420             | fsub                qword ptr [esp + 0x20]
            //   dd442440             | fld                 qword ptr [esp + 0x40]
            //   d9c1                 | fld                 st(1)

        $sequence_2 = { db45fc dd5dd4 dc65d4 dd5dcc db45f8 dd5dc4 }
            // n = 6, score = 100
            //   db45fc               | fild                dword ptr [ebp - 4]
            //   dd5dd4               | fstp                qword ptr [ebp - 0x2c]
            //   dc65d4               | fsub                qword ptr [ebp - 0x2c]
            //   dd5dcc               | fstp                qword ptr [ebp - 0x34]
            //   db45f8               | fild                dword ptr [ebp - 8]
            //   dd5dc4               | fstp                qword ptr [ebp - 0x3c]

        $sequence_3 = { dc442410 dd5c2410 e9???????? db8740010000 dc6c2418 dd5c2418 e9???????? }
            // n = 7, score = 100
            //   dc442410             | fadd                qword ptr [esp + 0x10]
            //   dd5c2410             | fstp                qword ptr [esp + 0x10]
            //   e9????????           |                     
            //   db8740010000         | fild                dword ptr [edi + 0x140]
            //   dc6c2418             | fsubr               qword ptr [esp + 0x18]
            //   dd5c2418             | fstp                qword ptr [esp + 0x18]
            //   e9????????           |                     

        $sequence_4 = { dd442404 dc0d???????? c3 83c0fe 83f803 0f87cd000000 ff2485bcd24500 }
            // n = 7, score = 100
            //   dd442404             | fld                 qword ptr [esp + 4]
            //   dc0d????????         |                     
            //   c3                   | ret                 
            //   83c0fe               | add                 eax, -2
            //   83f803               | cmp                 eax, 3
            //   0f87cd000000         | ja                  0xd3
            //   ff2485bcd24500       | jmp                 dword ptr [eax*4 + 0x45d2bc]

        $sequence_5 = { 7414 3d00020000 741a 8d542464 52 ff15???????? ebb2 }
            // n = 7, score = 100
            //   7414                 | je                  0x16
            //   3d00020000           | cmp                 eax, 0x200
            //   741a                 | je                  0x1c
            //   8d542464             | lea                 edx, [esp + 0x64]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   ebb2                 | jmp                 0xffffffb4

        $sequence_6 = { ff45f8 f682c1ed660004 894d08 7457 803900 7504 33ff }
            // n = 7, score = 100
            //   ff45f8               | inc                 dword ptr [ebp - 8]
            //   f682c1ed660004       | test                byte ptr [edx + 0x66edc1], 4
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   7457                 | je                  0x59
            //   803900               | cmp                 byte ptr [ecx], 0
            //   7504                 | jne                 6
            //   33ff                 | xor                 edi, edi

        $sequence_7 = { 53 e8???????? 83c404 8b45ec e9???????? 8be5 5d }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   e9????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_8 = { 64890d00000000 83c478 c20c00 8b8c2490000000 8b4658 5f 5e }
            // n = 7, score = 100
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   83c478               | add                 esp, 0x78
            //   c20c00               | ret                 0xc
            //   8b8c2490000000       | mov                 ecx, dword ptr [esp + 0x90]
            //   8b4658               | mov                 eax, dword ptr [esi + 0x58]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_9 = { ffd3 c786c400000000000000 57 ff15???????? 8b4c2440 5f 5e }
            // n = 7, score = 100
            //   ffd3                 | call                ebx
            //   c786c400000000000000     | mov    dword ptr [esi + 0xc4], 0
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 5177344
}