rule win_xpctra_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xpctra"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3300 3100 3300 45 0031 005700 2bc6 }
            // n = 7, score = 100
            //   3300                 | xor                 eax, dword ptr [eax]
            //   3100                 | xor                 dword ptr [eax], eax
            //   3300                 | xor                 eax, dword ptr [eax]
            //   45                   | inc                 ebp
            //   0031                 | add                 byte ptr [ecx], dh
            //   005700               | add                 byte ptr [edi], dl
            //   2bc6                 | sub                 eax, esi

        $sequence_1 = { 45 007100 3100 3300 3200 }
            // n = 5, score = 100
            //   45                   | inc                 ebp
            //   007100               | add                 byte ptr [ecx], dh
            //   3100                 | xor                 dword ptr [eax], eax
            //   3300                 | xor                 eax, dword ptr [eax]
            //   3200                 | xor                 al, byte ptr [eax]

        $sequence_2 = { 45 005700 57 0033 005100 51 }
            // n = 6, score = 100
            //   45                   | inc                 ebp
            //   005700               | add                 byte ptr [edi], dl
            //   57                   | push                edi
            //   0033                 | add                 byte ptr [ebx], dh
            //   005100               | add                 byte ptr [ecx], dl
            //   51                   | push                ecx

        $sequence_3 = { 65006500 3200 57 006500 3100 7100 }
            // n = 6, score = 100
            //   65006500             | add                 byte ptr gs:[ebp], ah
            //   3200                 | xor                 al, byte ptr [eax]
            //   57                   | push                edi
            //   006500               | add                 byte ptr [ebp], ah
            //   3100                 | xor                 dword ptr [eax], eax
            //   7100                 | jno                 2

        $sequence_4 = { 65007700 3100 3300 65007700 45 00fc }
            // n = 6, score = 100
            //   65007700             | add                 byte ptr gs:[edi], dh
            //   3100                 | xor                 dword ptr [eax], eax
            //   3300                 | xor                 eax, dword ptr [eax]
            //   65007700             | add                 byte ptr gs:[edi], dh
            //   45                   | inc                 ebp
            //   00fc                 | add                 ah, bh

        $sequence_5 = { 005100 004701 00ac0677007700 3100 7700 3300 51 }
            // n = 7, score = 100
            //   005100               | add                 byte ptr [ecx], dl
            //   004701               | add                 byte ptr [edi + 1], al
            //   00ac0677007700       | add                 byte ptr [esi + eax + 0x770077], ch
            //   3100                 | xor                 dword ptr [eax], eax
            //   7700                 | ja                  2
            //   3300                 | xor                 eax, dword ptr [eax]
            //   51                   | push                ecx

        $sequence_6 = { 7700 7700 650032 005100 57 005700 7700 }
            // n = 7, score = 100
            //   7700                 | ja                  2
            //   7700                 | ja                  2
            //   650032               | add                 byte ptr gs:[edx], dh
            //   005100               | add                 byte ptr [ecx], dl
            //   57                   | push                edi
            //   005700               | add                 byte ptr [edi], dl
            //   7700                 | ja                  2

        $sequence_7 = { 3100 3300 3200 57 005100 3100 }
            // n = 6, score = 100
            //   3100                 | xor                 dword ptr [eax], eax
            //   3300                 | xor                 eax, dword ptr [eax]
            //   3200                 | xor                 al, byte ptr [eax]
            //   57                   | push                edi
            //   005100               | add                 byte ptr [ecx], dl
            //   3100                 | xor                 dword ptr [eax], eax

        $sequence_8 = { 0033 0031 0032 0031 006500 3300 3100 }
            // n = 7, score = 100
            //   0033                 | add                 byte ptr [ebx], dh
            //   0031                 | add                 byte ptr [ecx], dh
            //   0032                 | add                 byte ptr [edx], dh
            //   0031                 | add                 byte ptr [ecx], dh
            //   006500               | add                 byte ptr [ebp], ah
            //   3300                 | xor                 eax, dword ptr [eax]
            //   3100                 | xor                 dword ptr [eax], eax

        $sequence_9 = { 007700 45 005700 3100 65007700 }
            // n = 5, score = 100
            //   007700               | add                 byte ptr [edi], dh
            //   45                   | inc                 ebp
            //   005700               | add                 byte ptr [edi], dl
            //   3100                 | xor                 dword ptr [eax], eax
            //   65007700             | add                 byte ptr gs:[edi], dh

    condition:
        7 of them and filesize < 11395072
}