rule win_xpertrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xpertrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xpertrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff08 40 0430 ff0a 4c 000c00 }
            // n = 6, score = 200
            //   ff08                 | dec                 dword ptr [eax]
            //   40                   | inc                 eax
            //   0430                 | add                 al, 0x30
            //   ff0a                 | dec                 dword ptr [edx]
            //   4c                   | dec                 esp
            //   000c00               | add                 byte ptr [eax + eax], cl

        $sequence_1 = { 045c ff4d40 ff08 40 }
            // n = 4, score = 200
            //   045c                 | add                 al, 0x5c
            //   ff4d40               | dec                 dword ptr [ebp + 0x40]
            //   ff08                 | dec                 dword ptr [eax]
            //   40                   | inc                 eax

        $sequence_2 = { 006c70ff 0808 008f38001b26 001b 0d002a2364 ff08 }
            // n = 6, score = 200
            //   006c70ff             | add                 byte ptr [eax + esi*2 - 1], ch
            //   0808                 | or                  byte ptr [eax], cl
            //   008f38001b26         | add                 byte ptr [edi + 0x261b0038], cl
            //   001b                 | add                 byte ptr [ebx], bl
            //   0d002a2364           | or                  eax, 0x64232a00
            //   ff08                 | dec                 dword ptr [eax]

        $sequence_3 = { 0870ff 0d80000700 0474 ff0478 }
            // n = 4, score = 200
            //   0870ff               | or                  byte ptr [eax - 1], dh
            //   0d80000700           | or                  eax, 0x70080
            //   0474                 | add                 al, 0x74
            //   ff0478               | inc                 dword ptr [eax + edi*2]

        $sequence_4 = { 0808 008a3800cc1c 5e 006c70ff 0808 008f38001b26 }
            // n = 6, score = 200
            //   0808                 | or                  byte ptr [eax], cl
            //   008a3800cc1c         | add                 byte ptr [edx + 0x1ccc0038], cl
            //   5e                   | pop                 esi
            //   006c70ff             | add                 byte ptr [eax + esi*2 - 1], ch
            //   0808                 | or                  byte ptr [eax], cl
            //   008f38001b26         | add                 byte ptr [edi + 0x261b0038], cl

        $sequence_5 = { ff05???????? 000d???????? 0878ff 0d98000700 6e }
            // n = 5, score = 200
            //   ff05????????         |                     
            //   000d????????         |                     
            //   0878ff               | or                  byte ptr [eax - 1], bh
            //   0d98000700           | or                  eax, 0x70098
            //   6e                   | outsb               dx, byte ptr [esi]

        $sequence_6 = { 6c 70ff 0808 008a3800cc1c }
            // n = 4, score = 200
            //   6c                   | insb                byte ptr es:[edi], dx
            //   70ff                 | jo                  1
            //   0808                 | or                  byte ptr [eax], cl
            //   008a3800cc1c         | add                 byte ptr [edx + 0x1ccc0038], cl

        $sequence_7 = { ff0a 250004003c 6c 70ff }
            // n = 4, score = 200
            //   ff0a                 | dec                 dword ptr [edx]
            //   250004003c           | and                 eax, 0x3c000400
            //   6c                   | insb                byte ptr es:[edi], dx
            //   70ff                 | jo                  1

        $sequence_8 = { ff15???????? 81c480000000 8d55c0 52 ff15???????? 8d4588 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   81c480000000         | add                 esp, 0x80
            //   8d55c0               | lea                 edx, [ebp - 0x40]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d4588               | lea                 eax, [ebp - 0x78]

        $sequence_9 = { ff15???????? 81c6a4000000 50 56 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   81c6a4000000         | add                 esi, 0xa4
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_10 = { ff15???????? 81e600020000 33c9 81fe00020000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   81e600020000         | and                 esi, 0x200
            //   33c9                 | xor                 ecx, ecx
            //   81fe00020000         | cmp                 esi, 0x200

        $sequence_11 = { ff15???????? 81c608030000 8d45e8 56 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   81c608030000         | add                 esi, 0x308
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   56                   | push                esi

        $sequence_12 = { ff15???????? 81c608030000 8d8568ffffff 56 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   81c608030000         | add                 esi, 0x308
            //   8d8568ffffff         | lea                 eax, [ebp - 0x98]
            //   56                   | push                esi

        $sequence_13 = { ff15???????? 81e600200000 33d2 81fe00200000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   81e600200000         | and                 esi, 0x2000
            //   33d2                 | xor                 edx, edx
            //   81fe00200000         | cmp                 esi, 0x2000

        $sequence_14 = { ff15???????? 81c480000000 8d8df8fcffff 51 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   81c480000000         | add                 esp, 0x80
            //   8d8df8fcffff         | lea                 ecx, [ebp - 0x308]
            //   51                   | push                ecx

        $sequence_15 = { ff15???????? 833d????????00 7505 dc7dc0 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   833d????????00       |                     
            //   7505                 | jne                 7
            //   dc7dc0               | fdivr               qword ptr [ebp - 0x40]

    condition:
        7 of them and filesize < 8560640
}