rule win_xsplus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xsplus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xsplus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b761c 8b4608 8b7e20 8b36 66394f18 75f2 }
            // n = 6, score = 400
            //   8b761c               | mov                 esi, dword ptr [esi + 0x1c]
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8b7e20               | mov                 edi, dword ptr [esi + 0x20]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   66394f18             | cmp                 word ptr [edi + 0x18], cx
            //   75f2                 | jne                 0xfffffff4

        $sequence_1 = { 8bec 83ec18 8b4518 8945f0 8b4d14 }
            // n = 5, score = 300
            //   8bec                 | mov                 ebp, esp
            //   83ec18               | sub                 esp, 0x18
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]

        $sequence_2 = { 8b55ec 8b01 3b4210 0f83af000000 6a01 8d4df8 51 }
            // n = 7, score = 300
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   3b4210               | cmp                 eax, dword ptr [edx + 0x10]
            //   0f83af000000         | jae                 0xb5
            //   6a01                 | push                1
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx

        $sequence_3 = { 8b5520 8955f8 8b451c 8945e8 8b4d10 83e102 85c9 }
            // n = 7, score = 300
            //   8b5520               | mov                 edx, dword ptr [ebp + 0x20]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   83e102               | and                 ecx, 2
            //   85c9                 | test                ecx, ecx

        $sequence_4 = { 83c201 8955f8 8b4514 8945f4 }
            // n = 4, score = 300
            //   83c201               | add                 edx, 1
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_5 = { aa a0???????? 8885c8fbffff b940000000 33c0 8dbdc9fbffff }
            // n = 6, score = 300
            //   aa                   | stosb               byte ptr es:[edi], al
            //   a0????????           |                     
            //   8885c8fbffff         | mov                 byte ptr [ebp - 0x438], al
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8dbdc9fbffff         | lea                 edi, [ebp - 0x437]

        $sequence_6 = { 85c0 7524 a1???????? a3???????? a1???????? c705????????04264000 8935???????? }
            // n = 7, score = 300
            //   85c0                 | test                eax, eax
            //   7524                 | jne                 0x26
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????04264000     |     
            //   8935????????         |                     

        $sequence_7 = { 8b8db4fdffff 81e9cd860100 898db4fdffff 83bdb4fdffff03 }
            // n = 4, score = 300
            //   8b8db4fdffff         | mov                 ecx, dword ptr [ebp - 0x24c]
            //   81e9cd860100         | sub                 ecx, 0x186cd
            //   898db4fdffff         | mov                 dword ptr [ebp - 0x24c], ecx
            //   83bdb4fdffff03       | cmp                 dword ptr [ebp - 0x24c], 3

        $sequence_8 = { 898da8feffff 8b95a8feffff 52 8b85ccfeffff 50 8d4de0 }
            // n = 6, score = 300
            //   898da8feffff         | mov                 dword ptr [ebp - 0x158], ecx
            //   8b95a8feffff         | mov                 edx, dword ptr [ebp - 0x158]
            //   52                   | push                edx
            //   8b85ccfeffff         | mov                 eax, dword ptr [ebp - 0x134]
            //   50                   | push                eax
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_9 = { 6804010000 8d85fcfeffff 50 6a00 ff15???????? 6804010000 8d8df0fcffff }
            // n = 7, score = 300
            //   6804010000           | push                0x104
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6804010000           | push                0x104
            //   8d8df0fcffff         | lea                 ecx, [ebp - 0x310]

        $sequence_10 = { 8985b8fdffff 81bdb8fdffff10010000 7723 81bdb8fdffff10010000 }
            // n = 4, score = 300
            //   8985b8fdffff         | mov                 dword ptr [ebp - 0x248], eax
            //   81bdb8fdffff10010000     | cmp    dword ptr [ebp - 0x248], 0x110
            //   7723                 | ja                  0x25
            //   81bdb8fdffff10010000     | cmp    dword ptr [ebp - 0x248], 0x110

        $sequence_11 = { 8b5508 89510c 8b45ec 8b4d0c 894808 8b55ec c7421000000000 }
            // n = 7, score = 300
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   89510c               | mov                 dword ptr [ecx + 0xc], edx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   c7421000000000       | mov                 dword ptr [edx + 0x10], 0

        $sequence_12 = { c74668e0a34000 6a0d e8???????? 59 8365fc00 ff7668 ff15???????? }
            // n = 7, score = 300
            //   c74668e0a34000       | mov                 dword ptr [esi + 0x68], 0x40a3e0
            //   6a0d                 | push                0xd
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   ff7668               | push                dword ptr [esi + 0x68]
            //   ff15????????         |                     

        $sequence_13 = { 8d85d0fcffff 50 8d8dc8fbffff 51 e8???????? }
            // n = 5, score = 300
            //   8d85d0fcffff         | lea                 eax, [ebp - 0x330]
            //   50                   | push                eax
            //   8d8dc8fbffff         | lea                 ecx, [ebp - 0x438]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_14 = { 0355fc 0fb602 33c1 8b4d0c 034dfc 8801 }
            // n = 6, score = 300
            //   0355fc               | add                 edx, dword ptr [ebp - 4]
            //   0fb602               | movzx               eax, byte ptr [edx]
            //   33c1                 | xor                 eax, ecx
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   034dfc               | add                 ecx, dword ptr [ebp - 4]
            //   8801                 | mov                 byte ptr [ecx], al

        $sequence_15 = { 8a8c181d010000 888808a74000 40 ebe6 }
            // n = 4, score = 300
            //   8a8c181d010000       | mov                 cl, byte ptr [eax + ebx + 0x11d]
            //   888808a74000         | mov                 byte ptr [eax + 0x40a708], cl
            //   40                   | inc                 eax
            //   ebe6                 | jmp                 0xffffffe8

        $sequence_16 = { 50 ff15???????? b801000000 e9???????? 8d95c4fdffff }
            // n = 5, score = 300
            //   50                   | push                eax
            //   ff15????????         |                     
            //   b801000000           | mov                 eax, 1
            //   e9????????           |                     
            //   8d95c4fdffff         | lea                 edx, [ebp - 0x23c]

    condition:
        7 of them and filesize < 597872
}