rule win_yahoyah_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yahoyah."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yahoyah"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 6a02 53 6af0 }
            // n = 4, score = 500
            //   ff15????????         |                     
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   6af0                 | push                -0x10

        $sequence_1 = { 23d1 52 8bd0 c1ea18 52 0fb6d0 }
            // n = 6, score = 400
            //   23d1                 | and                 edx, ecx
            //   52                   | push                edx
            //   8bd0                 | mov                 edx, eax
            //   c1ea18               | shr                 edx, 0x18
            //   52                   | push                edx
            //   0fb6d0               | movzx               edx, al

        $sequence_2 = { ff15???????? 85c0 7501 c3 56 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7501                 | jne                 3
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_3 = { 0fb6d0 52 c1e808 23c1 50 68???????? }
            // n = 6, score = 400
            //   0fb6d0               | movzx               edx, al
            //   52                   | push                edx
            //   c1e808               | shr                 eax, 8
            //   23c1                 | and                 eax, ecx
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_4 = { 81e100200000 7503 41 eb09 }
            // n = 4, score = 400
            //   81e100200000         | and                 ecx, 0x2000
            //   7503                 | jne                 5
            //   41                   | inc                 ecx
            //   eb09                 | jmp                 0xb

        $sequence_5 = { 50 e8???????? 59 53 53 6a03 0fb7c8 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a03                 | push                3
            //   0fb7c8               | movzx               ecx, ax

        $sequence_6 = { 50 6800080000 ff15???????? ff15???????? }
            // n = 4, score = 400
            //   50                   | push                eax
            //   6800080000           | push                0x800
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_7 = { 57 e8???????? 59 56 56 8d45fc 50 }
            // n = 7, score = 400
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   56                   | push                esi
            //   56                   | push                esi
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_8 = { 53 53 53 56 53 ff15???????? 68d0070000 }
            // n = 7, score = 400
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   68d0070000           | push                0x7d0

        $sequence_9 = { ff15???????? 6a2e 68???????? e8???????? }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   6a2e                 | push                0x2e
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_10 = { ff15???????? 6a3a 56 e8???????? 8bf0 83c410 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   6a3a                 | push                0x3a
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c410               | add                 esp, 0x10

        $sequence_11 = { 6a1a 50 e8???????? bf???????? }
            // n = 4, score = 300
            //   6a1a                 | push                0x1a
            //   50                   | push                eax
            //   e8????????           |                     
            //   bf????????           |                     

        $sequence_12 = { 90 90 68add13441 ffb53ffbffff }
            // n = 4, score = 100
            //   90                   | nop                 
            //   90                   | nop                 
            //   68add13441           | push                0x4134d1ad
            //   ffb53ffbffff         | push                dword ptr [ebp - 0x4c1]

        $sequence_13 = { 90 90 90 33c9 33c0 648b3530000000 8b760c }
            // n = 7, score = 100
            //   90                   | nop                 
            //   90                   | nop                 
            //   90                   | nop                 
            //   33c9                 | xor                 ecx, ecx
            //   33c0                 | xor                 eax, eax
            //   648b3530000000       | mov                 esi, dword ptr fs:[0x30]
            //   8b760c               | mov                 esi, dword ptr [esi + 0xc]

    condition:
        7 of them and filesize < 483328
}