rule win_yakuza_ransomware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yakuza_ransomware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yakuza_ransomware"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 c645fc5b 56 8bd0 8d8d20fbffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c645fc5b             | mov                 byte ptr [ebp - 4], 0x5b
            //   56                   | push                esi
            //   8bd0                 | mov                 edx, eax
            //   8d8d20fbffff         | lea                 ecx, [ebp - 0x4e0]
            //   e8????????           |                     

        $sequence_1 = { e8???????? 8d8520ffffff 83bd34ffffff08 0f438520ffffff 8d8dd8fbffff 51 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d8520ffffff         | lea                 eax, [ebp - 0xe0]
            //   83bd34ffffff08       | cmp                 dword ptr [ebp - 0xcc], 8
            //   0f438520ffffff       | cmovae              eax, dword ptr [ebp - 0xe0]
            //   8d8dd8fbffff         | lea                 ecx, [ebp - 0x428]
            //   51                   | push                ecx

        $sequence_2 = { 50 e8???????? 0fb74c242c 8d7f02 83c414 85c0 b8ffff0000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   0fb74c242c           | movzx               ecx, word ptr [esp + 0x2c]
            //   8d7f02               | lea                 edi, [edi + 2]
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   b8ffff0000           | mov                 eax, 0xffff

        $sequence_3 = { e9???????? c3 8b4568 83e002 0f840c000000 836568fd 8d4d48 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8b4568               | mov                 eax, dword ptr [ebp + 0x68]
            //   83e002               | and                 eax, 2
            //   0f840c000000         | je                  0x12
            //   836568fd             | and                 dword ptr [ebp + 0x68], 0xfffffffd
            //   8d4d48               | lea                 ecx, [ebp + 0x48]

        $sequence_4 = { e9???????? c3 8b4dec 81c180000000 e9???????? 8b4d08 83c104 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   81c180000000         | add                 ecx, 0x80
            //   e9????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c104               | add                 ecx, 4

        $sequence_5 = { 0fb6c9 0fb689409c4d00 3304cdd2735400 8b4df8 8b55fc 8b4c8a08 c1e900 }
            // n = 7, score = 100
            //   0fb6c9               | movzx               ecx, cl
            //   0fb689409c4d00       | movzx               ecx, byte ptr [ecx + 0x4d9c40]
            //   3304cdd2735400       | xor                 eax, dword ptr [ecx*8 + 0x5473d2]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b4c8a08             | mov                 ecx, dword ptr [edx + ecx*4 + 8]
            //   c1e900               | shr                 ecx, 0

        $sequence_6 = { e8???????? 84c0 0f84d0010000 8d8d54f6ffff e8???????? 8bf0 89b5d4f1ffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f84d0010000         | je                  0x1d6
            //   8d8d54f6ffff         | lea                 ecx, [ebp - 0x9ac]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   89b5d4f1ffff         | mov                 dword ptr [ebp - 0xe2c], esi

        $sequence_7 = { e8???????? c745fc00000000 8b4e24 85c9 7466 8b01 8d55dc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b4e24               | mov                 ecx, dword ptr [esi + 0x24]
            //   85c9                 | test                ecx, ecx
            //   7466                 | je                  0x68
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8d55dc               | lea                 edx, [ebp - 0x24]

        $sequence_8 = { ff7508 8d45a8 50 8d4de0 e8???????? 8bf0 8d4e04 }
            // n = 7, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   50                   | push                eax
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8d4e04               | lea                 ecx, [esi + 4]

        $sequence_9 = { 50 c745ac00000000 c745b007000000 e8???????? 837f1408 8bc7 7202 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   c745ac00000000       | mov                 dword ptr [ebp - 0x54], 0
            //   c745b007000000       | mov                 dword ptr [ebp - 0x50], 7
            //   e8????????           |                     
            //   837f1408             | cmp                 dword ptr [edi + 0x14], 8
            //   8bc7                 | mov                 eax, edi
            //   7202                 | jb                  4

    condition:
        7 of them and filesize < 2811904
}