rule win_yanluowang_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yanluowang."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yanluowang"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745dc00010001 c745e000010001 c745e400010001 c745e800010001 e8???????? 83c40c }
            // n = 6, score = 100
            //   c745dc00010001       | mov                 dword ptr [ebp - 0x24], 0x1000100
            //   c745e000010001       | mov                 dword ptr [ebp - 0x20], 0x1000100
            //   c745e400010001       | mov                 dword ptr [ebp - 0x1c], 0x1000100
            //   c745e800010001       | mov                 dword ptr [ebp - 0x18], 0x1000100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_1 = { 56 57 50 8d45f4 64a300000000 8995a4fdffff 898da0fdffff }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8995a4fdffff         | mov                 dword ptr [ebp - 0x25c], edx
            //   898da0fdffff         | mov                 dword ptr [ebp - 0x260], ecx

        $sequence_2 = { 33733c 334b30 335338 8bc1 0bce 33f7 23f8 }
            // n = 7, score = 100
            //   33733c               | xor                 esi, dword ptr [ebx + 0x3c]
            //   334b30               | xor                 ecx, dword ptr [ebx + 0x30]
            //   335338               | xor                 edx, dword ptr [ebx + 0x38]
            //   8bc1                 | mov                 eax, ecx
            //   0bce                 | or                  ecx, esi
            //   33f7                 | xor                 esi, edi
            //   23f8                 | and                 edi, eax

        $sequence_3 = { 8b442438 336c2434 03d5 0fb6e8 c1e808 339cae00040000 33d8 }
            // n = 7, score = 100
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   336c2434             | xor                 ebp, dword ptr [esp + 0x34]
            //   03d5                 | add                 edx, ebp
            //   0fb6e8               | movzx               ebp, al
            //   c1e808               | shr                 eax, 8
            //   339cae00040000       | xor                 ebx, dword ptr [esi + ebp*4 + 0x400]
            //   33d8                 | xor                 ebx, eax

        $sequence_4 = { c744242c00000000 8bc3 b902000000 f7f6 807c241300 8bf0 8b442418 }
            // n = 7, score = 100
            //   c744242c00000000     | mov                 dword ptr [esp + 0x2c], 0
            //   8bc3                 | mov                 eax, ebx
            //   b902000000           | mov                 ecx, 2
            //   f7f6                 | div                 esi
            //   807c241300           | cmp                 byte ptr [esp + 0x13], 0
            //   8bf0                 | mov                 esi, eax
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]

        $sequence_5 = { 7402 890b 3355e8 8d4808 85c9 7402 }
            // n = 6, score = 100
            //   7402                 | je                  4
            //   890b                 | mov                 dword ptr [ebx], ecx
            //   3355e8               | xor                 edx, dword ptr [ebp - 0x18]
            //   8d4808               | lea                 ecx, [eax + 8]
            //   85c9                 | test                ecx, ecx
            //   7402                 | je                  4

        $sequence_6 = { 0fbe41ff 8d04c528984400 ebbd 8a11 }
            // n = 4, score = 100
            //   0fbe41ff             | movsx               eax, byte ptr [ecx - 1]
            //   8d04c528984400       | lea                 eax, [eax*8 + 0x449828]
            //   ebbd                 | jmp                 0xffffffbf
            //   8a11                 | mov                 dl, byte ptr [ecx]

        $sequence_7 = { ebdf c745e4b4a44400 c745e803000000 ebcf c745e4b8a44400 ebbf c745e4c0a44400 }
            // n = 7, score = 100
            //   ebdf                 | jmp                 0xffffffe1
            //   c745e4b4a44400       | mov                 dword ptr [ebp - 0x1c], 0x44a4b4
            //   c745e803000000       | mov                 dword ptr [ebp - 0x18], 3
            //   ebcf                 | jmp                 0xffffffd1
            //   c745e4b8a44400       | mov                 dword ptr [ebp - 0x1c], 0x44a4b8
            //   ebbf                 | jmp                 0xffffffc1
            //   c745e4c0a44400       | mov                 dword ptr [ebp - 0x1c], 0x44a4c0

        $sequence_8 = { 0f87f4010000 0fb680bbc94200 ff24859fc94200 8365e400 8d4de4 8365e800 6a7b }
            // n = 7, score = 100
            //   0f87f4010000         | ja                  0x1fa
            //   0fb680bbc94200       | movzx               eax, byte ptr [eax + 0x42c9bb]
            //   ff24859fc94200       | jmp                 dword ptr [eax*4 + 0x42c99f]
            //   8365e400             | and                 dword ptr [ebp - 0x1c], 0
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   8365e800             | and                 dword ptr [ebp - 0x18], 0
            //   6a7b                 | push                0x7b

        $sequence_9 = { ff742418 6a00 6a00 6a04 6a01 }
            // n = 5, score = 100
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   6a01                 | push                1

    condition:
        7 of them and filesize < 834560
}