rule win_yibackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yibackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yibackdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c897ddf 488b18 e8???????? 488d4d6f 4c8bc3 48894c2440 }
            // n = 6, score = 100
            //   4c897ddf             | test                ecx, ecx
            //   488b18               | je                  0x62e
            //   e8????????           |                     
            //   488d4d6f             | ret                 
            //   4c8bc3               | dec                 eax
            //   48894c2440           | sub                 esp, 0x148

        $sequence_1 = { 33f6 4d85db 744a 4f8d0c00 498bf8 4d85c0 7439 }
            // n = 7, score = 100
            //   33f6                 | mov                 ebx, edx
            //   4d85db               | dec                 eax
            //   744a                 | test                eax, eax
            //   4f8d0c00             | je                  0x123f
            //   498bf8               | dec                 esp
            //   4d85c0               | mov                 ecx, dword ptr [esp + 0x30]
            //   7439                 | dec                 ebp

        $sequence_2 = { 743f 4180f97b 0f84b6000000 4180f92d 740e 4180e930 4180f909 }
            // n = 7, score = 100
            //   743f                 | inc                 ecx
            //   4180f97b             | or                  eax, 0xffffffff
            //   0f84b6000000         | dec                 eax
            //   4180f92d             | lea                 edx, [esp + 0x24]
            //   740e                 | dec                 eax
            //   4180e930             | lea                 ecx, [esp + 0x38]
            //   4180f909             | jb                  0x5e9

        $sequence_3 = { 33c9 e8???????? 488b4def ffd0 4c3965f7 741e 41b9fc000000 }
            // n = 7, score = 100
            //   33c9                 | call                eax
            //   e8????????           |                     
            //   488b4def             | dec                 eax
            //   ffd0                 | mov                 ecx, dword ptr [ebx + 0x38]
            //   4c3965f7             | inc                 ebp
            //   741e                 | xor                 ecx, ecx
            //   41b9fc000000         | inc                 ebp

        $sequence_4 = { ff15???????? 488b5c2450 448d4fda 33d2 33c9 41b842a86f9e e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488b5c2450           | test                eax, eax
            //   448d4fda             | dec                 eax
            //   33d2                 | test                eax, eax
            //   33c9                 | je                  0x1897
            //   41b842a86f9e         | dec                 ecx
            //   e8????????           |                     

        $sequence_5 = { 488bd8 e8???????? 488bcb 4c8b4008 488b10 e8???????? 488d15cd5c0000 }
            // n = 7, score = 100
            //   488bd8               | lea                 ecx, [ebp - 0x21]
            //   e8????????           |                     
            //   488bcb               | xor                 edx, edx
            //   4c8b4008             | xor                 ecx, ecx
            //   488b10               | inc                 ecx
            //   e8????????           |                     
            //   488d15cd5c0000       | mov                 ecx, 0xac

        $sequence_6 = { 448bc2 41c1e803 4183f80a 7de8 4d85d2 7464 4885db }
            // n = 7, score = 100
            //   448bc2               | mov                 dword ptr [esp + 0x20], ecx
            //   41c1e803             | dec                 ecx
            //   4183f80a             | mov                 ecx, esi
            //   7de8                 | inc                 ecx
            //   4d85d2               | lea                 edx, [eax + 0x16]
            //   7464                 | dec                 ebp
            //   4885db               | mov                 ecx, dword ptr [ecx]

        $sequence_7 = { 458bfe e8???????? 4533c9 4489742420 4533c0 33d2 }
            // n = 6, score = 100
            //   458bfe               | mov                 ebp, 2
            //   e8????????           |                     
            //   4533c9               | dec                 ecx
            //   4489742420           | add                 esi, ebp
            //   4533c0               | dec                 ecx
            //   33d2                 | add                 esi, 8

        $sequence_8 = { c3 33d2 488bc1 4885c9 7505 c3 4883c102 }
            // n = 7, score = 100
            //   c3                   | jb                  0x3ae
            //   33d2                 | mov                 eax, dword ptr [ebp + ecx*4 - 0x45]
            //   488bc1               | xor                 eax, 0x4c1a47af
            //   4885c9               | mov                 dword ptr [ebp + ecx*4 - 0x45], eax
            //   7505                 | dec                 eax
            //   c3                   | inc                 ecx
            //   4883c102             | dec                 eax

        $sequence_9 = { 488b5028 c745db05000000 e8???????? 488bd0 488d4de3 e8???????? }
            // n = 6, score = 100
            //   488b5028             | je                  0xb8a
            //   c745db05000000       | inc                 sp
            //   e8????????           |                     
            //   488bd0               | cmp                 dword ptr [ebx + 0x38], edi
            //   488d4de3             | je                  0xb8a
            //   e8????????           |                     

    condition:
        7 of them and filesize < 147456
}