rule win_ymir_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ymir."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ymir"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c89ea 4889c1 4c0f47c3 e8???????? }
            // n = 4, score = 100
            //   4c89ea               | lea                 eax, [0xfff98c96]
            //   4889c1               | dec                 esp
            //   4c0f47c3             | mov                 edx, ebp
            //   e8????????           |                     

        $sequence_1 = { 4c89ea 4889cb ff5078 488d05a7211000 }
            // n = 4, score = 100
            //   4c89ea               | dec                 esp
            //   4889cb               | mov                 ecx, esp
            //   ff5078               | dec                 esp
            //   488d05a7211000       | mov                 edx, ebp

        $sequence_2 = { 4c89ea 4889d9 41ff14fe eb85 }
            // n = 4, score = 100
            //   4c89ea               | dec                 eax
            //   4889d9               | mov                 ecx, eax
            //   41ff14fe             | dec                 ecx
            //   eb85                 | mov                 esp, eax

        $sequence_3 = { 4c89ea 4889c1 4989c4 e8???????? 488d1573bf0400 31c9 }
            // n = 6, score = 100
            //   4c89ea               | dec                 esp
            //   4889c1               | mov                 edx, ebp
            //   4989c4               | dec                 eax
            //   e8????????           |                     
            //   488d1573bf0400       | mov                 ecx, eax
            //   31c9                 | dec                 ecx

        $sequence_4 = { 4c89ea 4889c7 488d05ec682800 4c8d3585682800 }
            // n = 4, score = 100
            //   4c89ea               | dec                 esp
            //   4889c7               | lea                 eax, [0xfff7dbc6]
            //   488d05ec682800       | dec                 esp
            //   4c8d3585682800       | mov                 edx, ebp

        $sequence_5 = { 4c89ea 4889c6 498b0424 c744242001000000 }
            // n = 4, score = 100
            //   4c89ea               | lea                 eax, [0xfff834c0]
            //   4889c6               | dec                 esp
            //   498b0424             | mov                 edx, ebp
            //   c744242001000000     | dec                 eax

        $sequence_6 = { 4c89ea 4889d9 488ba8d8000000 4889ac2488000000 }
            // n = 4, score = 100
            //   4c89ea               | dec                 ecx
            //   4889d9               | mov                 esp, eax
            //   488ba8d8000000       | dec                 esp
            //   4889ac2488000000     | lea                 eax, [0xfff967f6]

        $sequence_7 = { 4c89ea 4889c1 e8???????? 4189f2 }
            // n = 4, score = 100
            //   4c89ea               | lea                 eax, [0xfff98c96]
            //   4889c1               | dec                 eax
            //   e8????????           |                     
            //   4189f2               | lea                 edx, [0x323cf]

    condition:
        7 of them and filesize < 5530624
}