rule win_younglotus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.younglotus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.younglotus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6802000080 e8???????? 83c41c 6a01 }
            // n = 4, score = 1000
            //   6802000080           | push                0x80000002
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   6a01                 | push                1

        $sequence_1 = { c745e800000000 c745fc00000000 837d0c03 754c 6a03 }
            // n = 5, score = 800
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   837d0c03             | cmp                 dword ptr [ebp + 0xc], 3
            //   754c                 | jne                 0x4e
            //   6a03                 | push                3

        $sequence_2 = { 8945c8 68???????? 8b45c8 50 }
            // n = 4, score = 800
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   68????????           |                     
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   50                   | push                eax

        $sequence_3 = { 83c404 8b4de0 51 ff55dc }
            // n = 4, score = 800
            //   83c404               | add                 esp, 4
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   51                   | push                ecx
            //   ff55dc               | call                dword ptr [ebp - 0x24]

        $sequence_4 = { c745ec00000000 c745fc00000000 8b450c 50 8b4d08 51 8b55e8 }
            // n = 7, score = 800
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]

        $sequence_5 = { 50 8b8d9cfeffff 51 ff15???????? c785a0feffff00000000 }
            // n = 5, score = 800
            //   50                   | push                eax
            //   8b8d9cfeffff         | mov                 ecx, dword ptr [ebp - 0x164]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   c785a0feffff00000000     | mov    dword ptr [ebp - 0x160], 0

        $sequence_6 = { 8b8d5cfeffff 83c114 e8???????? c645fc01 8b8d5cfeffff 83c124 e8???????? }
            // n = 7, score = 800
            //   8b8d5cfeffff         | mov                 ecx, dword ptr [ebp - 0x1a4]
            //   83c114               | add                 ecx, 0x14
            //   e8????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b8d5cfeffff         | mov                 ecx, dword ptr [ebp - 0x1a4]
            //   83c124               | add                 ecx, 0x24
            //   e8????????           |                     

        $sequence_7 = { 8b4508 50 e8???????? 83c404 8945a0 837da000 }
            // n = 6, score = 800
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax
            //   837da000             | cmp                 dword ptr [ebp - 0x60], 0

        $sequence_8 = { 53 56 57 68???????? ff15???????? 8945dc 68???????? }
            // n = 7, score = 600
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   68????????           |                     
            //   ff15????????         |                     
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   68????????           |                     

        $sequence_9 = { 8b703c 03f0 813e50450000 0f85e8000000 }
            // n = 4, score = 400
            //   8b703c               | mov                 esi, dword ptr [eax + 0x3c]
            //   03f0                 | add                 esi, eax
            //   813e50450000         | cmp                 dword ptr [esi], 0x4550
            //   0f85e8000000         | jne                 0xee

        $sequence_10 = { 83f802 7503 33c0 c3 6a01 58 }
            // n = 6, score = 400
            //   83f802               | cmp                 eax, 2
            //   7503                 | jne                 5
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   6a01                 | push                1
            //   58                   | pop                 eax

        $sequence_11 = { e8???????? 83c41c 8d85e8feffff 6804010000 53 50 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   6804010000           | push                0x104
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_12 = { 33f6 8975fc 397508 68ff010000 56 56 }
            // n = 6, score = 400
            //   33f6                 | xor                 esi, esi
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   397508               | cmp                 dword ptr [ebp + 8], esi
            //   68ff010000           | push                0x1ff
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_13 = { 85c0 8945f4 7e49 6a04 53 50 }
            // n = 6, score = 400
            //   85c0                 | test                eax, eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   7e49                 | jle                 0x4b
            //   6a04                 | push                4
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_14 = { ff750c ff7508 50 e8???????? 8d430f 83c40c }
            // n = 6, score = 400
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d430f               | lea                 eax, [ebx + 0xf]
            //   83c40c               | add                 esp, 0xc

        $sequence_15 = { bf00040000 57 8d85e4fbffff 53 50 e8???????? }
            // n = 6, score = 400
            //   bf00040000           | mov                 edi, 0x400
            //   57                   | push                edi
            //   8d85e4fbffff         | lea                 eax, [ebp - 0x41c]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 106496
}