rule win_zeoticus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zeoticus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeoticus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 660f6e9c248c000000 660f62d8 0f29942490000000 660f6e942414010000 660f62ca 660f6e9424a0000000 0f295c2410 }
            // n = 7, score = 100
            //   660f6e9c248c000000     | movd    xmm3, dword ptr [esp + 0x8c]
            //   660f62d8             | punpckldq           xmm3, xmm0
            //   0f29942490000000     | movaps              xmmword ptr [esp + 0x90], xmm2
            //   660f6e942414010000     | movd    xmm2, dword ptr [esp + 0x114]
            //   660f62ca             | punpckldq           xmm1, xmm2
            //   660f6e9424a0000000     | movd    xmm2, dword ptr [esp + 0xa0]
            //   0f295c2410           | movaps              xmmword ptr [esp + 0x10], xmm3

        $sequence_1 = { b9d0fe4bac e8???????? 83c408 a3???????? 6a00 6a00 }
            // n = 6, score = 100
            //   b9d0fe4bac           | mov                 ecx, 0xac4bfed0
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   a3????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_2 = { 660feff0 8345f010 0f117710 8345ec10 83c720 0f1002 }
            // n = 6, score = 100
            //   660feff0             | pxor                xmm6, xmm0
            //   8345f010             | add                 dword ptr [ebp - 0x10], 0x10
            //   0f117710             | movups              xmmword ptr [edi + 0x10], xmm6
            //   8345ec10             | add                 dword ptr [ebp - 0x14], 0x10
            //   83c720               | add                 edi, 0x20
            //   0f1002               | movups              xmm0, xmmword ptr [edx]

        $sequence_3 = { 8d8690101000 8bd7 8d8ee8101000 50 83ec08 e8???????? }
            // n = 6, score = 100
            //   8d8690101000         | lea                 eax, [esi + 0x101090]
            //   8bd7                 | mov                 edx, edi
            //   8d8ee8101000         | lea                 ecx, [esi + 0x1010e8]
            //   50                   | push                eax
            //   83ec08               | sub                 esp, 8
            //   e8????????           |                     

        $sequence_4 = { 0f286c2430 660fd4e0 0f29bc2490000000 660f73d03f 660f6eff 660fefe0 660f3a0fdd08 }
            // n = 7, score = 100
            //   0f286c2430           | movaps              xmm5, xmmword ptr [esp + 0x30]
            //   660fd4e0             | paddq               xmm4, xmm0
            //   0f29bc2490000000     | movaps              xmmword ptr [esp + 0x90], xmm7
            //   660f73d03f           | psrlq               xmm0, 0x3f
            //   660f6eff             | movd                xmm7, edi
            //   660fefe0             | pxor                xmm4, xmm0
            //   660f3a0fdd08         | palignr             xmm3, xmm5, 8

        $sequence_5 = { 8b842498010000 898424f0000000 8b84249c010000 898424f4000000 8b8424a0010000 898424f8000000 8b8424a4010000 }
            // n = 7, score = 100
            //   8b842498010000       | mov                 eax, dword ptr [esp + 0x198]
            //   898424f0000000       | mov                 dword ptr [esp + 0xf0], eax
            //   8b84249c010000       | mov                 eax, dword ptr [esp + 0x19c]
            //   898424f4000000       | mov                 dword ptr [esp + 0xf4], eax
            //   8b8424a0010000       | mov                 eax, dword ptr [esp + 0x1a0]
            //   898424f8000000       | mov                 dword ptr [esp + 0xf8], eax
            //   8b8424a4010000       | mov                 eax, dword ptr [esp + 0x1a4]

        $sequence_6 = { 8b4618 314718 8b461c 31471c 8b4620 }
            // n = 5, score = 100
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   314718               | xor                 dword ptr [edi + 0x18], eax
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   31471c               | xor                 dword ptr [edi + 0x1c], eax
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]

        $sequence_7 = { 50 6a00 ff15???????? 85c0 0f84e7000000 33db 33c9 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84e7000000         | je                  0xed
            //   33db                 | xor                 ebx, ebx
            //   33c9                 | xor                 ecx, ecx

        $sequence_8 = { 8b7020 03f3 0f1f4000 8b06 bac59d1c81 03c3 }
            // n = 6, score = 100
            //   8b7020               | mov                 esi, dword ptr [eax + 0x20]
            //   03f3                 | add                 esi, ebx
            //   0f1f4000             | nop                 dword ptr [eax]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   bac59d1c81           | mov                 edx, 0x811c9dc5
            //   03c3                 | add                 eax, ebx

        $sequence_9 = { 0f295c2410 0f28442410 660f62c1 660fd4c6 660f6ec9 660fd4c5 660f62ca }
            // n = 7, score = 100
            //   0f295c2410           | movaps              xmmword ptr [esp + 0x10], xmm3
            //   0f28442410           | movaps              xmm0, xmmword ptr [esp + 0x10]
            //   660f62c1             | punpckldq           xmm0, xmm1
            //   660fd4c6             | paddq               xmm0, xmm6
            //   660f6ec9             | movd                xmm1, ecx
            //   660fd4c5             | paddq               xmm0, xmm5
            //   660f62ca             | punpckldq           xmm1, xmm2

    condition:
        7 of them and filesize < 468992
}