rule win_zeroaccess_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zeroaccess."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeroaccess"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 7408 ff15???????? eb02 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa
            //   ff15????????         |                     
            //   eb02                 | jmp                 4

        $sequence_1 = { 8b01 ff761c ff7618 ff5004 }
            // n = 4, score = 300
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff761c               | push                dword ptr [esi + 0x1c]
            //   ff7618               | push                dword ptr [esi + 0x18]
            //   ff5004               | call                dword ptr [eax + 4]

        $sequence_2 = { 50 68???????? 6889001200 8d45fc }
            // n = 4, score = 300
            //   50                   | push                eax
            //   68????????           |                     
            //   6889001200           | push                0x120089
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_3 = { 6a01 8d45f4 50 ff7608 ff15???????? }
            // n = 5, score = 300
            //   6a01                 | push                1
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff15????????         |                     

        $sequence_4 = { 48 83c9ff c744242804000000 48 }
            // n = 4, score = 300
            //   48                   | dec                 eax
            //   83c9ff               | or                  ecx, 0xffffffff
            //   c744242804000000     | mov                 dword ptr [esp + 0x28], 4
            //   48                   | dec                 eax

        $sequence_5 = { 3bf8 730e 2bc7 e8???????? }
            // n = 4, score = 300
            //   3bf8                 | cmp                 edi, eax
            //   730e                 | jae                 0x10
            //   2bc7                 | sub                 eax, edi
            //   e8????????           |                     

        $sequence_6 = { 68060000c8 ff7708 ff15???????? 85c0 }
            // n = 4, score = 300
            //   68060000c8           | push                0xc8000006
            //   ff7708               | push                dword ptr [edi + 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 6a10 68???????? 68060000c8 ff7708 }
            // n = 4, score = 300
            //   6a10                 | push                0x10
            //   68????????           |                     
            //   68060000c8           | push                0xc8000006
            //   ff7708               | push                dword ptr [edi + 8]

        $sequence_8 = { 740c bf03000040 eb05 bf010000c0 85ff }
            // n = 5, score = 200
            //   740c                 | je                  0xe
            //   bf03000040           | mov                 edi, 0x40000003
            //   eb05                 | jmp                 7
            //   bf010000c0           | mov                 edi, 0xc0000001
            //   85ff                 | test                edi, edi

        $sequence_9 = { 3bc1 7604 83c8ff c3 }
            // n = 4, score = 200
            //   3bc1                 | cmp                 eax, ecx
            //   7604                 | jbe                 6
            //   83c8ff               | or                  eax, 0xffffffff
            //   c3                   | ret                 

        $sequence_10 = { ff15???????? 85c0 7407 b8e3030000 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   b8e3030000           | mov                 eax, 0x3e3

        $sequence_11 = { 89742438 897c2448 e8???????? 48 }
            // n = 4, score = 100
            //   89742438             | mov                 dword ptr [esp + 0x38], esi
            //   897c2448             | mov                 dword ptr [esp + 0x48], edi
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_12 = { eb06 ff15???????? 48 8b9520020000 4c }
            // n = 5, score = 100
            //   eb06                 | jmp                 8
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   8b9520020000         | mov                 edx, dword ptr [ebp + 0x220]
            //   4c                   | dec                 esp

        $sequence_13 = { 85c0 750c 8d7808 e8???????? ffcf 75f7 833d????????06 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   8d7808               | lea                 edi, [eax + 8]
            //   e8????????           |                     
            //   ffcf                 | dec                 edi
            //   75f7                 | jne                 0xfffffff9
            //   833d????????06       |                     

    condition:
        7 of them and filesize < 464896
}