rule win_zerocleare_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zerocleare."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zerocleare"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45d0 837de408 68???????? 0f4345d0 68000000c0 50 e8???????? }
            // n = 7, score = 100
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   837de408             | cmp                 dword ptr [ebp - 0x1c], 8
            //   68????????           |                     
            //   0f4345d0             | cmovae              eax, dword ptr [ebp - 0x30]
            //   68000000c0           | push                0xc0000000
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { ff249d01c04000 8b46e4 3b42e4 744f 0fb6f8 0fb642e4 2bf8 }
            // n = 7, score = 100
            //   ff249d01c04000       | jmp                 dword ptr [ebx*4 + 0x40c001]
            //   8b46e4               | mov                 eax, dword ptr [esi - 0x1c]
            //   3b42e4               | cmp                 eax, dword ptr [edx - 0x1c]
            //   744f                 | je                  0x51
            //   0fb6f8               | movzx               edi, al
            //   0fb642e4             | movzx               eax, byte ptr [edx - 0x1c]
            //   2bf8                 | sub                 edi, eax

        $sequence_2 = { 8b049d40fd4400 f644082801 7469 56 }
            // n = 4, score = 100
            //   8b049d40fd4400       | mov                 eax, dword ptr [ebx*4 + 0x44fd40]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7469                 | je                  0x6b
            //   56                   | push                esi

        $sequence_3 = { 8b0cb540fd4400 83c410 8985f4efffff 8bc2 8b95f4efffff }
            // n = 5, score = 100
            //   8b0cb540fd4400       | mov                 ecx, dword ptr [esi*4 + 0x44fd40]
            //   83c410               | add                 esp, 0x10
            //   8985f4efffff         | mov                 dword ptr [ebp - 0x100c], eax
            //   8bc2                 | mov                 eax, edx
            //   8b95f4efffff         | mov                 edx, dword ptr [ebp - 0x100c]

        $sequence_4 = { 6a05 e8???????? 83c404 6a00 ff74f704 ff34f7 }
            // n = 6, score = 100
            //   6a05                 | push                5
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6a00                 | push                0
            //   ff74f704             | push                dword ptr [edi + esi*8 + 4]
            //   ff34f7               | push                dword ptr [edi + esi*8]

        $sequence_5 = { 56 8b7508 ff34b5109f4300 e8???????? 50 ff34b52c9f4300 8d4dec }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   ff34b5109f4300       | push                dword ptr [esi*4 + 0x439f10]
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff34b52c9f4300       | push                dword ptr [esi*4 + 0x439f2c]
            //   8d4dec               | lea                 ecx, [ebp - 0x14]

        $sequence_6 = { 7cde 68???????? e8???????? 8b8504f8ffff }
            // n = 4, score = 100
            //   7cde                 | jl                  0xffffffe0
            //   68????????           |                     
            //   e8????????           |                     
            //   8b8504f8ffff         | mov                 eax, dword ptr [ebp - 0x7fc]

        $sequence_7 = { 83c404 89460c 83fa08 722e }
            // n = 4, score = 100
            //   83c404               | add                 esp, 4
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   83fa08               | cmp                 edx, 8
            //   722e                 | jb                  0x30

        $sequence_8 = { 833d????????00 0f852ce4ffff 8d0dc0524400 ba1b000000 e9???????? a900000080 }
            // n = 6, score = 100
            //   833d????????00       |                     
            //   0f852ce4ffff         | jne                 0xffffe432
            //   8d0dc0524400         | lea                 ecx, [0x4452c0]
            //   ba1b000000           | mov                 edx, 0x1b
            //   e9????????           |                     
            //   a900000080           | test                eax, 0x80000000

        $sequence_9 = { c7401000000000 c7401407000000 668908 c645fc04 8b9530f7ffff 83fa08 727f }
            // n = 7, score = 100
            //   c7401000000000       | mov                 dword ptr [eax + 0x10], 0
            //   c7401407000000       | mov                 dword ptr [eax + 0x14], 7
            //   668908               | mov                 word ptr [eax], cx
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8b9530f7ffff         | mov                 edx, dword ptr [ebp - 0x8d0]
            //   83fa08               | cmp                 edx, 8
            //   727f                 | jb                  0x81

    condition:
        7 of them and filesize < 42670080
}