rule win_zeus_openssl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zeus_openssl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeus_openssl"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf8 05fffeffff 4e 03c6 }
            // n = 4, score = 1300
            //   8bf8                 | mov                 edi, eax
            //   05fffeffff           | add                 eax, 0xfffffeff
            //   4e                   | dec                 esi
            //   03c6                 | add                 eax, esi

        $sequence_1 = { 0181a8160000 837de000 7419 8b75e0 8b45f0 0fb7443002 8b75f8 }
            // n = 7, score = 1300
            //   0181a8160000         | add                 dword ptr [ecx + 0x16a8], eax
            //   837de000             | cmp                 dword ptr [ebp - 0x20], 0
            //   7419                 | je                  0x1b
            //   8b75e0               | mov                 esi, dword ptr [ebp - 0x20]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   0fb7443002           | movzx               eax, word ptr [eax + esi + 2]
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]

        $sequence_2 = { 2bc3 8bda 8b55c4 83c005 894304 8b45f0 2bd6 }
            // n = 7, score = 1300
            //   2bc3                 | sub                 eax, ebx
            //   8bda                 | mov                 ebx, edx
            //   8b55c4               | mov                 edx, dword ptr [ebp - 0x3c]
            //   83c005               | add                 eax, 5
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   2bd6                 | sub                 edx, esi

        $sequence_3 = { 6a1c 8945f0 8845ff 8bfa 32c0 59 }
            // n = 6, score = 1300
            //   6a1c                 | push                0x1c
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8845ff               | mov                 byte ptr [ebp - 1], al
            //   8bfa                 | mov                 edi, edx
            //   32c0                 | xor                 al, al
            //   59                   | pop                 ecx

        $sequence_4 = { 8bec 83ec10 53 56 57 8b3d???????? 33db }
            // n = 7, score = 1300
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   33db                 | xor                 ebx, ebx

        $sequence_5 = { 83ec0c 56 57 8bf2 8bf9 e8???????? }
            // n = 6, score = 1300
            //   83ec0c               | sub                 esp, 0xc
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf2                 | mov                 esi, edx
            //   8bf9                 | mov                 edi, ecx
            //   e8????????           |                     

        $sequence_6 = { 83c408 8b87bc160000 894df8 83f810 7530 8b4f14 }
            // n = 6, score = 1300
            //   83c408               | add                 esp, 8
            //   8b87bc160000         | mov                 eax, dword ptr [edi + 0x16bc]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   83f810               | cmp                 eax, 0x10
            //   7530                 | jne                 0x32
            //   8b4f14               | mov                 ecx, dword ptr [edi + 0x14]

        $sequence_7 = { 743b 83ef50 7412 83ef75 742a }
            // n = 5, score = 1300
            //   743b                 | je                  0x3d
            //   83ef50               | sub                 edi, 0x50
            //   7412                 | je                  0x14
            //   83ef75               | sub                 edi, 0x75
            //   742a                 | je                  0x2c

        $sequence_8 = { 89475c e8???????? 8b0f 33c0 394110 5f }
            // n = 6, score = 1300
            //   89475c               | mov                 dword ptr [edi + 0x5c], eax
            //   e8????????           |                     
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   33c0                 | xor                 eax, eax
            //   394110               | cmp                 dword ptr [ecx + 0x10], eax
            //   5f                   | pop                 edi

        $sequence_9 = { 8b45fc 48 50 8d9694000000 8bce }
            // n = 5, score = 1300
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   48                   | dec                 eax
            //   50                   | push                eax
            //   8d9694000000         | lea                 edx, [esi + 0x94]
            //   8bce                 | mov                 ecx, esi

    condition:
        7 of them and filesize < 4546560
}