rule win_zloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 e8???????? 83c40c 84c0 740b }
            // n = 5, score = 2000
            //   51                   | push                eax
            //   e8????????           |                     
            //   83c40c               | push                ecx
            //   84c0                 | add                 esp, 0xc
            //   740b                 | test                al, al

        $sequence_1 = { 6a00 e8???????? 83c408 56 6a08 }
            // n = 5, score = 2000
            //   6a00                 | add                 esp, 0xc
            //   e8????????           |                     
            //   83c408               | mov                 ecx, esi
            //   56                   | xor                 ebx, ebx
            //   6a08                 | lea                 ecx, [ebp - 0x110]

        $sequence_2 = { 53 e8???????? 83c404 89c6 8d0436 50 53 }
            // n = 7, score = 2000
            //   53                   | lea                 ebx, [ebp - 0x110]
            //   e8????????           |                     
            //   83c404               | push                ebx
            //   89c6                 | push                eax
            //   8d0436               | push                dword ptr [ebp + 8]
            //   50                   | push                ebx
            //   53                   | add                 esp, 0xc

        $sequence_3 = { 0fb7c0 57 50 53 e8???????? 83c40c 89f1 }
            // n = 7, score = 2000
            //   0fb7c0               | push                edi
            //   57                   | mov                 edi, dword ptr [esp + 0x14]
            //   50                   | mov                 byte ptr [eax + esi], 0
            //   53                   | pop                 esi
            //   e8????????           |                     
            //   83c40c               | ret                 
            //   89f1                 | push                esi

        $sequence_4 = { 55 89e5 8b4d08 e8???????? 6aff 50 68???????? }
            // n = 7, score = 2000
            //   55                   | mov                 word ptr [ebx + edi*2], 0
            //   89e5                 | mov                 eax, esi
            //   8b4d08               | pop                 esi
            //   e8????????           |                     
            //   6aff                 | pop                 edi
            //   50                   | push                ebx
            //   68????????           |                     

        $sequence_5 = { 0fb7450c 8d9df0feffff 53 50 ff7508 e8???????? }
            // n = 6, score = 2000
            //   0fb7450c             | push                edi
            //   8d9df0feffff         | push                eax
            //   53                   | push                ebx
            //   50                   | add                 esp, 0xc
            //   ff7508               | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_6 = { 31db 8d8df0feffff e8???????? 89d8 81c404010000 }
            // n = 5, score = 2000
            //   31db                 | mov                 ecx, esi
            //   8d8df0feffff         | movzx               eax, ax
            //   e8????????           |                     
            //   89d8                 | push                edi
            //   81c404010000         | push                eax

        $sequence_7 = { 53 e8???????? 83c40c 66c7047b0000 89f0 5e 5f }
            // n = 7, score = 2000
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c40c               | movzx               eax, word ptr [ebp + 0xc]
            //   66c7047b0000         | lea                 ebx, [ebp - 0x110]
            //   89f0                 | push                ebx
            //   5e                   | push                eax
            //   5f                   | movzx               eax, word ptr [ebp + 0xc]

        $sequence_8 = { 56 50 a1???????? 89c1 }
            // n = 4, score = 1300
            //   56                   | push                esi
            //   50                   | sub                 esp, 0x2a8
            //   a1????????           |                     
            //   89c1                 | mov                 dword ptr [esp + 0x130], esi

        $sequence_9 = { e8???????? 89c1 89f0 99 }
            // n = 4, score = 1200
            //   e8????????           |                     
            //   89c1                 | mov                 ecx, eax
            //   89f0                 | mov                 eax, esi
            //   99                   | cdq                 

        $sequence_10 = { e8???????? 4889c1 ba01000000 e8???????? a801 }
            // n = 5, score = 900
            //   e8????????           |                     
            //   4889c1               | dec                 eax
            //   ba01000000           | mov                 ecx, eax
            //   e8????????           |                     
            //   a801                 | mov                 edx, 1

        $sequence_11 = { ffd0 83f800 0f9dc0 2401 }
            // n = 4, score = 900
            //   ffd0                 | jmp                 4
            //   83f800               | call                eax
            //   0f9dc0               | cmp                 eax, 0
            //   2401                 | jne                 0xa

        $sequence_12 = { ffd0 b001 2401 0fb6c0 }
            // n = 4, score = 900
            //   ffd0                 | jmp                 2
            //   b001                 | jmp                 4
            //   2401                 | jmp                 2
            //   0fb6c0               | jmp                 2

        $sequence_13 = { e8???????? eb00 eb00 eb00 eb00 eb00 }
            // n = 6, score = 900
            //   e8????????           |                     
            //   eb00                 | test                al, 1
            //   eb00                 | jne                 0xb
            //   eb00                 | jmp                 2
            //   eb00                 | jmp                 2
            //   eb00                 | jmp                 2

        $sequence_14 = { ffd0 83f800 7505 e9???????? }
            // n = 4, score = 900
            //   ffd0                 | movzx               eax, al
            //   83f800               | jmp                 2
            //   7505                 | jmp                 2
            //   e9????????           |                     

        $sequence_15 = { e8???????? a801 7502 eb0d }
            // n = 4, score = 900
            //   e8????????           |                     
            //   a801                 | test                al, 1
            //   7502                 | jne                 4
            //   eb0d                 | jmp                 0xf

        $sequence_16 = { 41b802000000 e8???????? a801 7505 }
            // n = 4, score = 900
            //   41b802000000         | push                esi
            //   e8????????           |                     
            //   a801                 | push                dword ptr [esp + 0x10]
            //   7505                 | mov                 esi, dword ptr [esp + 0xc]

        $sequence_17 = { eb00 eb00 e9???????? eb00 e8???????? }
            // n = 5, score = 900
            //   eb00                 | jmp                 4
            //   eb00                 | jmp                 6
            //   e9????????           |                     
            //   eb00                 | jmp                 8
            //   e8????????           |                     

        $sequence_18 = { 57 56 50 8b4510 31db }
            // n = 5, score = 700
            //   57                   | mov                 dword ptr [ebp - 0x14], eax
            //   56                   | push                esi
            //   50                   | push                eax
            //   8b4510               | mov                 ecx, eax
            //   31db                 | push                ebx

        $sequence_19 = { 59 84c0 7432 68???????? }
            // n = 4, score = 700
            //   59                   | push                dword ptr [esp + 8]
            //   84c0                 | pop                 ecx
            //   7432                 | pop                 ecx
            //   68????????           |                     

        $sequence_20 = { 7432 68???????? ff742408 e8???????? 59 }
            // n = 5, score = 700
            //   7432                 | jmp                 0x15
            //   68????????           |                     
            //   ff742408             | mov                 dword ptr [esp + 0x20], 2
            //   e8????????           |                     
            //   59                   | and                 al, 1

        $sequence_21 = { 8bc3 5b c3 8b44240c 83f8ff 750a ff742408 }
            // n = 7, score = 700
            //   8bc3                 | pop                 ecx
            //   5b                   | pop                 ecx
            //   c3                   | je                  0x34
            //   8b44240c             | push                dword ptr [esp + 8]
            //   83f8ff               | mov                 eax, ebx
            //   750a                 | pop                 ebx
            //   ff742408             | ret                 

        $sequence_22 = { ff742410 ff742410 6a00 e8???????? 83c414 c3 56 }
            // n = 7, score = 600
            //   ff742410             | mov                 dword ptr [esp + 0x44], edx
            //   ff742410             | add                 eax, eax
            //   6a00                 | mov                 word ptr [esp + 0x38], ax
            //   e8????????           |                     
            //   83c414               | mov                 eax, dword ptr [esp + 0x38]
            //   c3                   | push                dword ptr [esp + 0x10]
            //   56                   | push                dword ptr [esp + 0x10]

        $sequence_23 = { 03c0 6689442438 8b442438 83c002 }
            // n = 4, score = 600
            //   03c0                 | mov                 eax, ebx
            //   6689442438           | pop                 ebx
            //   8b442438             | ret                 
            //   83c002               | mov                 eax, dword ptr [esp + 0xc]

        $sequence_24 = { 7cf5 5f c6043000 5e c3 56 }
            // n = 6, score = 600
            //   7cf5                 | ret                 
            //   5f                   | push                esi
            //   c6043000             | push                edi
            //   5e                   | jl                  0xfffffff7
            //   c3                   | pop                 edi
            //   56                   | mov                 byte ptr [eax + esi], 0

        $sequence_25 = { 6aff 50 e8???????? 8d857cffffff 50 }
            // n = 5, score = 600
            //   6aff                 | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d857cffffff         | lea                 eax, [esp + 0x3c]
            //   50                   | cdq                 

        $sequence_26 = { 5e c3 56 57 8b7c2414 83ffff }
            // n = 6, score = 600
            //   5e                   | push                ebx
            //   c3                   | push                esi
            //   56                   | push                edi
            //   57                   | push                dword ptr [ebp + 0xc]
            //   8b7c2414             | xor                 ebx, ebx
            //   83ffff               | push                0x80

        $sequence_27 = { 8d442418 99 52 50 8d44243c 99 52 }
            // n = 7, score = 600
            //   8d442418             | add                 eax, eax
            //   99                   | mov                 word ptr [esp + 0x38], ax
            //   52                   | mov                 eax, dword ptr [esp + 0x38]
            //   50                   | add                 eax, 2
            //   8d44243c             | lea                 eax, [esp + 0x18]
            //   99                   | cdq                 
            //   52                   | push                edx

        $sequence_28 = { 50 89542444 e8???????? 03c0 6689442438 }
            // n = 5, score = 600
            //   50                   | mov                 word ptr [esp + 0x38], ax
            //   89542444             | mov                 eax, dword ptr [esp + 0x38]
            //   e8????????           |                     
            //   03c0                 | add                 eax, 2
            //   6689442438           | mov                 word ptr [esp + 0x3a], ax

        $sequence_29 = { 50 56 56 56 ff7514 }
            // n = 5, score = 600
            //   50                   | ret                 
            //   56                   | push                esi
            //   56                   | push                edi
            //   56                   | cmp                 edx, eax
            //   ff7514               | jl                  0xfffffff7

        $sequence_30 = { 83c414 c3 56 ff742410 8b74240c ff742410 }
            // n = 6, score = 600
            //   83c414               | ret                 
            //   c3                   | push                esi
            //   56                   | push                dword ptr [esp + 0x10]
            //   ff742410             | mov                 esi, dword ptr [esp + 0xc]
            //   8b74240c             | push                0
            //   ff742410             | add                 esp, 0x14

        $sequence_31 = { c7462401000000 c7462800004001 e8???????? 89460c }
            // n = 4, score = 500
            //   c7462401000000       | push                eax
            //   c7462800004001       | push                esi
            //   e8????????           |                     
            //   89460c               | push                esi

        $sequence_32 = { e9???????? ff4c2408 7406 33c0 }
            // n = 4, score = 500
            //   e9????????           |                     
            //   ff4c2408             | mov                 esi, dword ptr [esp + 0xc]
            //   7406                 | push                dword ptr [esp + 0x10]
            //   33c0                 | push                esi

        $sequence_33 = { e8???????? 83c414 c3 8b542404 85d2 7503 }
            // n = 6, score = 500
            //   e8????????           |                     
            //   83c414               | push                esi
            //   c3                   | push                dword ptr [ebp + 0x14]
            //   8b542404             | push                0
            //   85d2                 | add                 esp, 0x14
            //   7503                 | ret                 

        $sequence_34 = { 89e5 53 57 56 81eca8020000 }
            // n = 5, score = 500
            //   89e5                 | ret                 
            //   53                   | mov                 edx, dword ptr [esp + 4]
            //   57                   | test                edx, edx
            //   56                   | jne                 0xf
            //   81eca8020000         | mov                 dword ptr [esi + 4], 0x1388

        $sequence_35 = { 83c1fc 894c2404 890424 e8???????? }
            // n = 4, score = 400
            //   83c1fc               | push                ebx
            //   894c2404             | push                edi
            //   890424               | push                esi
            //   e8????????           |                     

        $sequence_36 = { 89b42430010000 8b842430010000 8b842430010000 890424 c74424041c010000 e8???????? c74424101c010000 }
            // n = 7, score = 400
            //   89b42430010000       | sub                 esp, 0x2a8
            //   8b842430010000       | push                ebp
            //   8b842430010000       | mov                 ebp, esp
            //   890424               | push                ebx
            //   c74424041c010000     | push                edi
            //   e8????????           |                     
            //   c74424101c010000     | push                esi

        $sequence_37 = { 68???????? ff742410 e8???????? 6823af2930 56 ff742410 e8???????? }
            // n = 7, score = 300
            //   68????????           |                     
            //   ff742410             | push                dword ptr [esp + 8]
            //   e8????????           |                     
            //   6823af2930           | pop                 ecx
            //   56                   | test                al, al
            //   ff742410             | je                  0x34
            //   e8????????           |                     

        $sequence_38 = { 33f6 e8???????? ff7508 8d85f0fdffff 68???????? }
            // n = 5, score = 300
            //   33f6                 | lea                 eax, [ebp - 0x210]
            //   e8????????           |                     
            //   ff7508               | push                0x104
            //   8d85f0fdffff         | push                eax
            //   68????????           |                     

        $sequence_39 = { 53 56 57 ff750c 33db 68???????? }
            // n = 6, score = 300
            //   53                   | push                dword ptr [esp + 8]
            //   56                   | xor                 ebx, ebx
            //   57                   | push                0x80
            //   ff750c               | push                eax
            //   33db                 | add                 esp, 0x10
            //   68????????           |                     

        $sequence_40 = { 5f 5e 5b c3 8bc2 ebf8 53 }
            // n = 7, score = 300
            //   5f                   | test                edx, edx
            //   5e                   | jne                 0xb
            //   5b                   | xor                 eax, eax
            //   c3                   | push                eax
            //   8bc2                 | push                0x72
            //   ebf8                 | pop                 ecx
            //   53                   | pop                 ecx

        $sequence_41 = { 8d8578fdffff 50 68???????? 6804010000 ff7508 e8???????? }
            // n = 6, score = 300
            //   8d8578fdffff         | mov                 edx, dword ptr [esp + 4]
            //   50                   | test                edx, edx
            //   68????????           |                     
            //   6804010000           | jne                 0xc
            //   ff7508               | xor                 eax, eax
            //   e8????????           |                     

        $sequence_42 = { 50 6a72 e8???????? 59 }
            // n = 4, score = 300
            //   50                   | lea                 eax, [ebp - 0x288]
            //   6a72                 | push                eax
            //   e8????????           |                     
            //   59                   | push                eax

        $sequence_43 = { 33db 68???????? 6880000000 50 e8???????? 83c410 }
            // n = 6, score = 300
            //   33db                 | pop                 ecx
            //   68????????           |                     
            //   6880000000           | pop                 ecx
            //   50                   | test                al, al
            //   e8????????           |                     
            //   83c410               | je                  0x3d

        $sequence_44 = { 50 e8???????? 8d4580 50 8d8578fdffff 50 68???????? }
            // n = 7, score = 300
            //   50                   | jne                 0xc
            //   e8????????           |                     
            //   8d4580               | lea                 eax, [ebp - 0x288]
            //   50                   | push                eax
            //   8d8578fdffff         | push                0x104
            //   50                   | push                dword ptr [ebp + 8]
            //   68????????           |                     

        $sequence_45 = { ebf7 8d442410 50 ff742410 ff742410 ff742410 e8???????? }
            // n = 7, score = 300
            //   ebf7                 | push                eax
            //   8d442410             | push                0x72
            //   50                   | pop                 ecx
            //   ff742410             | pop                 edi
            //   ff742410             | pop                 esi
            //   ff742410             | pop                 ebx
            //   e8????????           |                     

        $sequence_46 = { e8???????? 68???????? 56 e8???????? 8bf0 59 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   68????????           |                     
            //   56                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | push                dword ptr [esp + 0x10]
            //   59                   | push                0x3029af23

        $sequence_47 = { c3 56 8b742408 6804010000 68???????? }
            // n = 5, score = 300
            //   c3                   | lea                 eax, [ebp - 0x210]
            //   56                   | push                dword ptr [ebp + 8]
            //   8b742408             | lea                 eax, [ebp - 0x210]
            //   6804010000           | push                0x104
            //   68????????           |                     

    condition:
        7 of them and filesize < 5360640
}