rule win_zupdax_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zupdax."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zupdax"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 8b06 50 895e0c 895e10 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   50                   | push                eax
            //   895e0c               | mov                 dword ptr [esi + 0xc], ebx
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx

        $sequence_1 = { 8b4c2408 8b7e28 51 e8???????? 8b5624 52 e8???????? }
            // n = 7, score = 200
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8b7e28               | mov                 edi, dword ptr [esi + 0x28]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b5624               | mov                 edx, dword ptr [esi + 0x24]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_2 = { 56 57 33c9 33f6 33ff 394c2414 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c9                 | xor                 ecx, ecx
            //   33f6                 | xor                 esi, esi
            //   33ff                 | xor                 edi, edi
            //   394c2414             | cmp                 dword ptr [esp + 0x14], ecx

        $sequence_3 = { 7522 e8???????? 8b0d???????? 51 8b0d???????? }
            // n = 5, score = 200
            //   7522                 | jne                 0x24
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   8b0d????????         |                     

        $sequence_4 = { e8???????? 83c408 8b4618 50 895e24 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   50                   | push                eax
            //   895e24               | mov                 dword ptr [esi + 0x24], ebx

        $sequence_5 = { 51 e8???????? 83c418 8bc6 c3 }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8bc6                 | mov                 eax, esi
            //   c3                   | ret                 

        $sequence_6 = { 895e2c e8???????? 8b460c 83c404 3bc3 }
            // n = 5, score = 200
            //   895e2c               | mov                 dword ptr [esi + 0x2c], ebx
            //   e8????????           |                     
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   83c404               | add                 esp, 4
            //   3bc3                 | cmp                 eax, ebx

        $sequence_7 = { 52 e8???????? 83c408 8b06 50 895e0c 895e10 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   50                   | push                eax
            //   895e0c               | mov                 dword ptr [esi + 0xc], ebx
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx

        $sequence_8 = { 3bc3 7419 8b4c2408 8b7e28 51 }
            // n = 5, score = 200
            //   3bc3                 | cmp                 eax, ebx
            //   7419                 | je                  0x1b
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8b7e28               | mov                 edi, dword ptr [esi + 0x28]
            //   51                   | push                ecx

        $sequence_9 = { 8d4618 6a00 50 c706ffffffff }
            // n = 4, score = 200
            //   8d4618               | lea                 eax, [esi + 0x18]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c706ffffffff         | mov                 dword ptr [esi], 0xffffffff

    condition:
        7 of them and filesize < 1032192
}