rule elf_bashlite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects elf.bashlite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.bashlite"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb0a c785ecefffff00000000 8b85ecefffff c9 c3 55 }
            // n = 6, score = 300
            //   eb0a                 | mov                 dword ptr [ebp - 0x2c], eax
            //   c785ecefffff00000000     | mov    word ptr [ebp - 0x30], 2
            //   8b85ecefffff         | mov                 eax, dword ptr [ebp - 0x3c]
            //   c9                   | movzx               edi, ax
            //   c3                   | mov                 dword ptr [ebp - 0x2c], eax
            //   55                   | cmp                 dword ptr [ebp - 0x2c], 1

        $sequence_1 = { f7d0 21d0 3345fc c9 c3 55 }
            // n = 6, score = 300
            //   f7d0                 | add                 eax, 8
            //   21d0                 | dec                 eax
            //   3345fc               | mov                 eax, dword ptr [eax]
            //   c9                   | dec                 eax
            //   c3                   | mov                 dword ptr [ebp - 0xb0], eax
            //   55                   | dec                 eax

        $sequence_2 = { 89c2 89d0 c1e81f 01d0 d1f8 }
            // n = 5, score = 300
            //   89c2                 | inc                 esp
            //   89d0                 | mov                 dword ptr [ebp - 0x2c], ecx
            //   c1e81f               | mov                 dword ptr [ebp - 0x38], 0
            //   01d0                 | mov                 dword ptr [ebp - 0x20], edx
            //   d1f8                 | mov                 eax, dword ptr [ebp - 0x20]

        $sequence_3 = { eb0a c785ecefffff00000000 8b85ecefffff c9 }
            // n = 4, score = 300
            //   eb0a                 | dec                 eax
            //   c785ecefffff00000000     | arpl    bx, si
            //   8b85ecefffff         | dec                 esp
            //   c9                   | mov                 edx, ebp

        $sequence_4 = { e8???????? 8945ec 837dec00 750b 8b45ec }
            // n = 5, score = 300
            //   e8????????           |                     
            //   8945ec               | mov                 edi, ebx
            //   837dec00             | dec                 eax
            //   750b                 | mov                 edx, ebp
            //   8b45ec               | inc                 esp

        $sequence_5 = { 85c0 750c c785ecefffff01000000 eb0a }
            // n = 4, score = 300
            //   85c0                 | cmp                 eax, 0x30
            //   750c                 | je                  0xdc5
            //   c785ecefffff01000000     | dec    eax
            //   eb0a                 | mov                 ebp, edi

        $sequence_6 = { eb0d e8???????? c70061000000 31d2 }
            // n = 4, score = 300
            //   eb0d                 | test                ebx, ebx
            //   e8????????           |                     
            //   c70061000000         | jne                 0xffffffe9
            //   31d2                 | dec                 eax

        $sequence_7 = { 760f e8???????? c7001c000000 31c0 }
            // n = 4, score = 300
            //   760f                 | jne                 0x81
            //   e8????????           |                     
            //   c7001c000000         | mov                 dword ptr [ebp - 0x40], 0
            //   31c0                 | dec                 eax

        $sequence_8 = { 750c c785ecefffff01000000 eb0a c785ecefffff00000000 8b85ecefffff c9 c3 }
            // n = 7, score = 300
            //   750c                 | jmp                 0x1b4
            //   c785ecefffff01000000     | dec    esp
            //   eb0a                 | mov                 edi, esi
            //   c785ecefffff00000000     | dec    eax
            //   8b85ecefffff         | mov                 edi, dword ptr [esp]
            //   c9                   | je                  0x1bf
            //   c3                   | sub                 esp, 0xc

        $sequence_9 = { c785ecefffff01000000 eb0a c785ecefffff00000000 8b85ecefffff c9 }
            // n = 5, score = 300
            //   c785ecefffff01000000     | mov    dword ptr [esp + 8], 3
            //   eb0a                 | mov                 dword ptr [esp + 4], 0
            //   c785ecefffff00000000     | mov    eax, dword ptr [ebp - 0x1c]
            //   8b85ecefffff         | mov                 dword ptr [esp], eax
            //   c9                   | mov                 dword ptr [esp + 8], 4

    condition:
        7 of them and filesize < 2310144
}