rule win_5t_downloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.5t_downloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.5t_downloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 8b4508 85c0 7416 83781400 7510 }
            // n = 6, score = 500
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   83781400             | cmp                 dword ptr [eax + 0x14], 0
            //   7510                 | jne                 0x12

        $sequence_1 = { 85c9 7409 83781800 7403 5d ffe1 }
            // n = 6, score = 500
            //   85c9                 | test                ecx, ecx
            //   7409                 | je                  0xb
            //   83781800             | cmp                 dword ptr [eax + 0x18], 0
            //   7403                 | je                  5
            //   5d                   | pop                 ebp
            //   ffe1                 | jmp                 ecx

        $sequence_2 = { 8b4508 85c0 7416 83781400 7510 }
            // n = 5, score = 500
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   83781400             | cmp                 dword ptr [eax + 0x14], 0
            //   7510                 | jne                 0x12

        $sequence_3 = { 8b4508 85c0 7416 83781400 }
            // n = 4, score = 500
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   83781400             | cmp                 dword ptr [eax + 0x14], 0

        $sequence_4 = { 7403 5d ffe1 83c8ff }
            // n = 4, score = 500
            //   7403                 | je                  5
            //   5d                   | pop                 ebp
            //   ffe1                 | jmp                 ecx
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_5 = { 83781800 7403 5d ffe1 83c8ff }
            // n = 5, score = 500
            //   83781800             | cmp                 dword ptr [eax + 0x18], 0
            //   7403                 | je                  5
            //   5d                   | pop                 ebp
            //   ffe1                 | jmp                 ecx
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_6 = { 85c0 7416 83781400 7510 }
            // n = 4, score = 500
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   83781400             | cmp                 dword ptr [eax + 0x14], 0
            //   7510                 | jne                 0x12

        $sequence_7 = { 85c9 7409 83781800 7403 5d }
            // n = 5, score = 500
            //   85c9                 | test                ecx, ecx
            //   7409                 | je                  0xb
            //   83781800             | cmp                 dword ptr [eax + 0x18], 0
            //   7403                 | je                  5
            //   5d                   | pop                 ebp

        $sequence_8 = { 83781800 7403 5d ffe1 }
            // n = 4, score = 500
            //   83781800             | cmp                 dword ptr [eax + 0x18], 0
            //   7403                 | je                  5
            //   5d                   | pop                 ebp
            //   ffe1                 | jmp                 ecx

        $sequence_9 = { 7409 83781800 7403 5d }
            // n = 4, score = 500
            //   7409                 | je                  0xb
            //   83781800             | cmp                 dword ptr [eax + 0x18], 0
            //   7403                 | je                  5
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 539648
}