rule win_8t_dropper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.8t_dropper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.8t_dropper"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c9ff f2ae f7d1 49 c6440c0c52 }
            // n = 5, score = 200
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   c6440c0c52           | mov                 byte ptr [esp + ecx + 0xc], 0x52

        $sequence_1 = { 83c40c c3 8b442408 83f801 }
            // n = 4, score = 200
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   83f801               | cmp                 eax, 1

        $sequence_2 = { 8d942410010000 6804010000 52 68???????? ff15???????? 8d842410010000 68???????? }
            // n = 7, score = 200
            //   8d942410010000       | lea                 edx, [esp + 0x110]
            //   6804010000           | push                0x104
            //   52                   | push                edx
            //   68????????           |                     
            //   ff15????????         |                     
            //   8d842410010000       | lea                 eax, [esp + 0x110]
            //   68????????           |                     

        $sequence_3 = { 8bc6 5f 5e 5b c9 c3 ff35???????? }
            // n = 7, score = 200
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 
            //   ff35????????         |                     

        $sequence_4 = { 49 51 68???????? 6a02 50 8b442418 }
            // n = 6, score = 200
            //   49                   | dec                 ecx
            //   51                   | push                ecx
            //   68????????           |                     
            //   6a02                 | push                2
            //   50                   | push                eax
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]

        $sequence_5 = { 6801000080 ff15???????? bf???????? 83c9ff 33c0 }
            // n = 5, score = 200
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 683f000f00 50 52 6801000080 ff15???????? bf???????? 83c9ff }
            // n = 7, score = 200
            //   683f000f00           | push                0xf003f
            //   50                   | push                eax
            //   52                   | push                edx
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_7 = { 51 ff15???????? 8d942410010000 6804010000 52 68???????? }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d942410010000       | lea                 edx, [esp + 0x110]
            //   6804010000           | push                0x104
            //   52                   | push                edx
            //   68????????           |                     

        $sequence_8 = { 83c408 85f6 741b 56 6800700000 6a01 }
            // n = 6, score = 200
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   741b                 | je                  0x1d
            //   56                   | push                esi
            //   6800700000           | push                0x7000
            //   6a01                 | push                1

        $sequence_9 = { 7559 8b4c2408 51 ff15???????? 8d942410010000 6804010000 }
            // n = 6, score = 200
            //   7559                 | jne                 0x5b
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d942410010000       | lea                 edx, [esp + 0x110]
            //   6804010000           | push                0x104

    condition:
        7 of them and filesize < 147456
}