rule win_abaddon_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.abaddon_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.abaddon_pos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750a 83fb3c 7605 e9???????? }
            // n = 4, score = 200
            //   750a                 | jne                 0xc
            //   83fb3c               | cmp                 ebx, 0x3c
            //   7605                 | jbe                 7
            //   e9????????           |                     

        $sequence_1 = { 7417 80fa00 7612 80fa7c 7505 e9???????? }
            // n = 6, score = 100
            //   7417                 | je                  0x19
            //   80fa00               | cmp                 dl, 0
            //   7612                 | jbe                 0x14
            //   80fa7c               | cmp                 dl, 0x7c
            //   7505                 | jne                 7
            //   e9????????           |                     

        $sequence_2 = { 42 89d9 01d1 803930 7205 803939 760f }
            // n = 7, score = 100
            //   42                   | inc                 edx
            //   89d9                 | mov                 ecx, ebx
            //   01d1                 | add                 ecx, edx
            //   803930               | cmp                 byte ptr [ecx], 0x30
            //   7205                 | jb                  7
            //   803939               | cmp                 byte ptr [ecx], 0x39
            //   760f                 | jbe                 0x11

        $sequence_3 = { 80fd3e 7406 41 80fd3f 756e 49 }
            // n = 6, score = 100
            //   80fd3e               | cmp                 ch, 0x3e
            //   7406                 | je                  8
            //   41                   | inc                 ecx
            //   80fd3f               | cmp                 ch, 0x3f
            //   756e                 | jne                 0x70
            //   49                   | dec                 ecx

        $sequence_4 = { 0fafc3 038560feffff 6a00 6a00 }
            // n = 4, score = 100
            //   0fafc3               | imul                eax, ebx
            //   038560feffff         | add                 eax, dword ptr [ebp - 0x1a0]
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 6860ea0000 ffb40564feffff ff15???????? 89d8 6bc004 }
            // n = 5, score = 100
            //   6860ea0000           | push                0xea60
            //   ffb40564feffff       | push                dword ptr [ebp + eax - 0x19c]
            //   ff15????????         |                     
            //   89d8                 | mov                 eax, ebx
            //   6bc004               | imul                eax, eax, 4

        $sequence_6 = { 740a 80393d 7405 803944 7536 80bea80100000d }
            // n = 6, score = 100
            //   740a                 | je                  0xc
            //   80393d               | cmp                 byte ptr [ecx], 0x3d
            //   7405                 | je                  7
            //   803944               | cmp                 byte ptr [ecx], 0x44
            //   7536                 | jne                 0x38
            //   80bea80100000d       | cmp                 byte ptr [esi + 0x1a8], 0xd

        $sequence_7 = { 6a00 ff15???????? 8945f0 6a00 ff15???????? c785c0feffff28010000 6a00 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   c785c0feffff28010000     | mov    dword ptr [ebp - 0x140], 0x128
            //   6a00                 | push                0

        $sequence_8 = { 31c0 48 31d2 8a841eb8010000 }
            // n = 4, score = 100
            //   31c0                 | xor                 eax, eax
            //   48                   | dec                 eax
            //   31d2                 | xor                 edx, edx
            //   8a841eb8010000       | mov                 al, byte ptr [esi + ebx + 0x1b8]

        $sequence_9 = { 7605 e9???????? 48 034510 48 0500040000 803800 }
            // n = 7, score = 100
            //   7605                 | jbe                 7
            //   e9????????           |                     
            //   48                   | dec                 eax
            //   034510               | add                 eax, dword ptr [ebp + 0x10]
            //   48                   | dec                 eax
            //   0500040000           | add                 eax, 0x400
            //   803800               | cmp                 byte ptr [eax], 0

        $sequence_10 = { 89e5 48 83ec20 48 c7c100000000 }
            // n = 5, score = 100
            //   89e5                 | mov                 ebp, esp
            //   48                   | dec                 eax
            //   83ec20               | sub                 esp, 0x20
            //   48                   | dec                 eax
            //   c7c100000000         | mov                 ecx, 0

        $sequence_11 = { 2c30 80ea30 666bc00a 48 01d0 48 89da }
            // n = 7, score = 100
            //   2c30                 | sub                 al, 0x30
            //   80ea30               | sub                 dl, 0x30
            //   666bc00a             | imul                ax, ax, 0xa
            //   48                   | dec                 eax
            //   01d0                 | add                 eax, edx
            //   48                   | dec                 eax
            //   89da                 | mov                 edx, ebx

        $sequence_12 = { 48 89c7 48 8d86b8010000 48 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   89c7                 | mov                 edi, eax
            //   48                   | dec                 eax
            //   8d86b8010000         | lea                 eax, [esi + 0x1b8]
            //   48                   | dec                 eax

        $sequence_13 = { 81c3f8030000 8903 48 31db 48 8b96d0050000 }
            // n = 6, score = 100
            //   81c3f8030000         | add                 ebx, 0x3f8
            //   8903                 | mov                 dword ptr [ebx], eax
            //   48                   | dec                 eax
            //   31db                 | xor                 ebx, ebx
            //   48                   | dec                 eax
            //   8b96d0050000         | mov                 edx, dword ptr [esi + 0x5d0]

        $sequence_14 = { 750d c6013d c786b401000002000000 eb13 }
            // n = 4, score = 100
            //   750d                 | jne                 0xf
            //   c6013d               | mov                 byte ptr [ecx], 0x3d
            //   c786b401000002000000     | mov    dword ptr [esi + 0x1b4], 2
            //   eb13                 | jmp                 0x15

    condition:
        7 of them and filesize < 40960
}