rule win_abbath_banker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.abbath_banker"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5a e8???????? 8bd6 8b45fc 8b08 ff511c 33c0 }
            // n = 7, score = 100
            //   5a                   | pop                 edx
            //   e8????????           |                     
            //   8bd6                 | mov                 edx, esi
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff511c               | call                dword ptr [ecx + 0x1c]
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { e8???????? 8b45e4 e8???????? 83f807 7cc6 ff75e8 b809000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   83f807               | cmp                 eax, 7
            //   7cc6                 | jl                  0xffffffc8
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   b809000000           | mov                 eax, 9

        $sequence_2 = { 0f84ed000000 833d????????0a 7d65 8d55fc 8b8314030000 e8???????? }
            // n = 6, score = 100
            //   0f84ed000000         | je                  0xf3
            //   833d????????0a       |                     
            //   7d65                 | jge                 0x67
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   8b8314030000         | mov                 eax, dword ptr [ebx + 0x314]
            //   e8????????           |                     

        $sequence_3 = { e8???????? 50 6883040000 57 e8???????? 8b83ec040000 8b4014 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   6883040000           | push                0x483
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b83ec040000         | mov                 eax, dword ptr [ebx + 0x4ec]
            //   8b4014               | mov                 eax, dword ptr [eax + 0x14]

        $sequence_4 = { e8???????? 0fb7c0 8a9834234900 668b07 e8???????? 0fb7c0 8a8034234900 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb7c0               | movzx               eax, ax
            //   8a9834234900         | mov                 bl, byte ptr [eax + 0x492334]
            //   668b07               | mov                 ax, word ptr [edi]
            //   e8????????           |                     
            //   0fb7c0               | movzx               eax, ax
            //   8a8034234900         | mov                 al, byte ptr [eax + 0x492334]

        $sequence_5 = { 50 e8???????? eb16 8b83ec040000 8a9320050000 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   eb16                 | jmp                 0x18
            //   8b83ec040000         | mov                 eax, dword ptr [ebx + 0x4ec]
            //   8a9320050000         | mov                 dl, byte ptr [ebx + 0x520]

        $sequence_6 = { 50 ffd5 83f801 1bdb 43 8bc3 81c4a4000000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ffd5                 | call                ebp
            //   83f801               | cmp                 eax, 1
            //   1bdb                 | sbb                 ebx, ebx
            //   43                   | inc                 ebx
            //   8bc3                 | mov                 eax, ebx
            //   81c4a4000000         | add                 esp, 0xa4

        $sequence_7 = { 8b5590 a1???????? 8b08 ff5138 33c0 a3???????? ba???????? }
            // n = 7, score = 100
            //   8b5590               | mov                 edx, dword ptr [ebp - 0x70]
            //   a1????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5138               | call                dword ptr [ecx + 0x38]
            //   33c0                 | xor                 eax, eax
            //   a3????????           |                     
            //   ba????????           |                     

        $sequence_8 = { 8b5e18 33c0 33d2 c74308???????? c7430ce87a4600 c74310587b4600 c74314b8184700 }
            // n = 7, score = 100
            //   8b5e18               | mov                 ebx, dword ptr [esi + 0x18]
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx
            //   c74308????????       |                     
            //   c7430ce87a4600       | mov                 dword ptr [ebx + 0xc], 0x467ae8
            //   c74310587b4600       | mov                 dword ptr [ebx + 0x10], 0x467b58
            //   c74314b8184700       | mov                 dword ptr [ebx + 0x14], 0x4718b8

        $sequence_9 = { 8b550c 8b8334040000 ff9330040000 eb02 33c0 5b }
            // n = 6, score = 100
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b8334040000         | mov                 eax, dword ptr [ebx + 0x434]
            //   ff9330040000         | call                dword ptr [ebx + 0x430]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx

    condition:
        7 of them and filesize < 1409024
}