rule win_absentloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.absentloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.absentloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4ddc e8???????? 83c610 3bf7 75f0 8b7dc8 eb3c }
            // n = 7, score = 200
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   83c610               | add                 esi, 0x10
            //   3bf7                 | cmp                 esi, edi
            //   75f0                 | jne                 0xfffffff2
            //   8b7dc8               | mov                 edi, dword ptr [ebp - 0x38]
            //   eb3c                 | jmp                 0x3e

        $sequence_1 = { 66c745f8722e 8b08 a1???????? 3b8104000000 7e33 56 be74a806fd }
            // n = 7, score = 200
            //   66c745f8722e         | mov                 word ptr [ebp - 8], 0x2e72
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   a1????????           |                     
            //   3b8104000000         | cmp                 eax, dword ptr [ecx + 4]
            //   7e33                 | jle                 0x35
            //   56                   | push                esi
            //   be74a806fd           | mov                 esi, 0xfd06a874

        $sequence_2 = { 0fb60438 8a88901a06fd 8ac2 c0e804 c0e102 0ac8 c0e204 }
            // n = 7, score = 200
            //   0fb60438             | movzx               eax, byte ptr [eax + edi]
            //   8a88901a06fd         | mov                 cl, byte ptr [eax - 0x2f9e570]
            //   8ac2                 | mov                 al, dl
            //   c0e804               | shr                 al, 4
            //   c0e102               | shl                 cl, 2
            //   0ac8                 | or                  cl, al
            //   c0e204               | shl                 dl, 4

        $sequence_3 = { ff75f4 8b09 8b01 ff5004 5f 5e 5b }
            // n = 7, score = 200
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5004               | call                dword ptr [eax + 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_4 = { a5 e8???????? 59 59 8bf0 8b8d5cffffff 8d8520ffffff }
            // n = 7, score = 200
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax
            //   8b8d5cffffff         | mov                 ecx, dword ptr [ebp - 0xa4]
            //   8d8520ffffff         | lea                 eax, [ebp - 0xe0]

        $sequence_5 = { 0f844c040000 8d4590 50 8d4ddc e8???????? 33d2 42 }
            // n = 7, score = 200
            //   0f844c040000         | je                  0x452
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   50                   | push                eax
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   42                   | inc                 edx

        $sequence_6 = { e8???????? 833d????????ff 59 7520 8b45f4 68800705fd a3???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   833d????????ff       |                     
            //   59                   | pop                 ecx
            //   7520                 | jne                 0x22
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   68800705fd           | push                0xfd050780
            //   a3????????           |                     

        $sequence_7 = { e8???????? 56 8d8d68faffff c645fc2e }
            // n = 4, score = 200
            //   e8????????           |                     
            //   56                   | push                esi
            //   8d8d68faffff         | lea                 ecx, [ebp - 0x598]
            //   c645fc2e             | mov                 byte ptr [ebp - 4], 0x2e

        $sequence_8 = { 03cf 03c7 0fb70470 8b0481 8d8de4f3ffff 51 8d8df0f3ffff }
            // n = 7, score = 200
            //   03cf                 | add                 ecx, edi
            //   03c7                 | add                 eax, edi
            //   0fb70470             | movzx               eax, word ptr [eax + esi*2]
            //   8b0481               | mov                 eax, dword ptr [ecx + eax*4]
            //   8d8de4f3ffff         | lea                 ecx, [ebp - 0xc1c]
            //   51                   | push                ecx
            //   8d8df0f3ffff         | lea                 ecx, [ebp - 0xc10]

        $sequence_9 = { 8b0c8de8a006fd 804c112802 5b 2bf7 83e6fe 5f 8bc6 }
            // n = 7, score = 200
            //   8b0c8de8a006fd       | mov                 ecx, dword ptr [ecx*4 - 0x2f95f18]
            //   804c112802           | or                  byte ptr [ecx + edx + 0x28], 2
            //   5b                   | pop                 ebx
            //   2bf7                 | sub                 esi, edi
            //   83e6fe               | and                 esi, 0xfffffffe
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

    condition:
        7 of them and filesize < 794624
}