rule win_acbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.acbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acbackdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 7428 c744240440000000 892c24 8944241c e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7428                 | je                  0x2a
            //   c744240440000000     | mov                 dword ptr [esp + 4], 0x40
            //   892c24               | mov                 dword ptr [esp], ebp
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   e8????????           |                     

        $sequence_1 = { c744240c01090000 c7442408???????? c744240401000000 891c24 e8???????? e9???????? c7442410b3904a00 }
            // n = 7, score = 100
            //   c744240c01090000     | mov                 dword ptr [esp + 0xc], 0x901
            //   c7442408????????     |                     
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   e9????????           |                     
            //   c7442410b3904a00     | mov                 dword ptr [esp + 0x10], 0x4a90b3

        $sequence_2 = { c78424c40000008c68059b c78424c80000006bbd41fb c78424cc000000abd9831f c78424d000000079217e13 c78424d400000019cde05b 89842458010000 83fb02 }
            // n = 7, score = 100
            //   c78424c40000008c68059b     | mov    dword ptr [esp + 0xc4], 0x9b05688c
            //   c78424c80000006bbd41fb     | mov    dword ptr [esp + 0xc8], 0xfb41bd6b
            //   c78424cc000000abd9831f     | mov    dword ptr [esp + 0xcc], 0x1f83d9ab
            //   c78424d000000079217e13     | mov    dword ptr [esp + 0xd0], 0x137e2179
            //   c78424d400000019cde05b     | mov    dword ptr [esp + 0xd4], 0x5be0cd19
            //   89842458010000       | mov                 dword ptr [esp + 0x158], eax
            //   83fb02               | cmp                 ebx, 2

        $sequence_3 = { e8???????? 85c0 0f848d000000 89c6 83c414 89f0 5b }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f848d000000         | je                  0x93
            //   89c6                 | mov                 esi, eax
            //   83c414               | add                 esp, 0x14
            //   89f0                 | mov                 eax, esi
            //   5b                   | pop                 ebx

        $sequence_4 = { e9???????? 8b95fc0d0000 8b85f80d0000 89542444 83c201 89442440 0f840f050000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b95fc0d0000         | mov                 edx, dword ptr [ebp + 0xdfc]
            //   8b85f80d0000         | mov                 eax, dword ptr [ebp + 0xdf8]
            //   89542444             | mov                 dword ptr [esp + 0x44], edx
            //   83c201               | add                 edx, 1
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   0f840f050000         | je                  0x515

        $sequence_5 = { 89c7 8b442414 c744240440000000 890424 e8???????? 83c46c 89f8 }
            // n = 7, score = 100
            //   89c7                 | mov                 edi, eax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   c744240440000000     | mov                 dword ptr [esp + 4], 0x40
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83c46c               | add                 esp, 0x6c
            //   89f8                 | mov                 eax, edi

        $sequence_6 = { 89d6 c1ee19 8b0c8da0d64a00 c1e305 83e60f c1e104 0b0cb5a0d64a00 }
            // n = 7, score = 100
            //   89d6                 | mov                 esi, edx
            //   c1ee19               | shr                 esi, 0x19
            //   8b0c8da0d64a00       | mov                 ecx, dword ptr [ecx*4 + 0x4ad6a0]
            //   c1e305               | shl                 ebx, 5
            //   83e60f               | and                 esi, 0xf
            //   c1e104               | shl                 ecx, 4
            //   0b0cb5a0d64a00       | or                  ecx, dword ptr [esi*4 + 0x4ad6a0]

        $sequence_7 = { 89742460 89542464 e9???????? c744242009000000 bd10000000 bb08000000 c744241403000000 }
            // n = 7, score = 100
            //   89742460             | mov                 dword ptr [esp + 0x60], esi
            //   89542464             | mov                 dword ptr [esp + 0x64], edx
            //   e9????????           |                     
            //   c744242009000000     | mov                 dword ptr [esp + 0x20], 9
            //   bd10000000           | mov                 ebp, 0x10
            //   bb08000000           | mov                 ebx, 8
            //   c744241403000000     | mov                 dword ptr [esp + 0x14], 3

        $sequence_8 = { 8d7904 c70100000000 31c0 83e7fc c74411fc00000000 29f9 01d1 }
            // n = 7, score = 100
            //   8d7904               | lea                 edi, [ecx + 4]
            //   c70100000000         | mov                 dword ptr [ecx], 0
            //   31c0                 | xor                 eax, eax
            //   83e7fc               | and                 edi, 0xfffffffc
            //   c74411fc00000000     | mov                 dword ptr [ecx + edx - 4], 0
            //   29f9                 | sub                 ecx, edi
            //   01d1                 | add                 ecx, edx

        $sequence_9 = { 8b442424 39d8 0f8784080000 8d7e04 29c3 39fb 0f8277080000 }
            // n = 7, score = 100
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   39d8                 | cmp                 eax, ebx
            //   0f8784080000         | ja                  0x88a
            //   8d7e04               | lea                 edi, [esi + 4]
            //   29c3                 | sub                 ebx, eax
            //   39fb                 | cmp                 ebx, edi
            //   0f8277080000         | jb                  0x87d

    condition:
        7 of them and filesize < 1704960
}