rule win_acronym_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.acronym."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acronym"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4da4 8b5508 8b8578ffffff 89048a 8b4d9c 83c101 894d9c }
            // n = 7, score = 200
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b8578ffffff         | mov                 eax, dword ptr [ebp - 0x88]
            //   89048a               | mov                 dword ptr [edx + ecx*4], eax
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   83c101               | add                 ecx, 1
            //   894d9c               | mov                 dword ptr [ebp - 0x64], ecx

        $sequence_1 = { 8b4dfc 8b4904 e8???????? 8b55f4 8955d0 8b45d0 }
            // n = 6, score = 200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   e8????????           |                     
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]

        $sequence_2 = { 8bb540e5ffff e9???????? 8bb540e5ffff e9???????? 8b8530e5ffff 8b048590174300 f644060480 }
            // n = 7, score = 200
            //   8bb540e5ffff         | mov                 esi, dword ptr [ebp - 0x1ac0]
            //   e9????????           |                     
            //   8bb540e5ffff         | mov                 esi, dword ptr [ebp - 0x1ac0]
            //   e9????????           |                     
            //   8b8530e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad0]
            //   8b048590174300       | mov                 eax, dword ptr [eax*4 + 0x431790]
            //   f644060480           | test                byte ptr [esi + eax + 4], 0x80

        $sequence_3 = { 754f 8b0d???????? e8???????? 85c0 753a 33c9 75fc }
            // n = 7, score = 200
            //   754f                 | jne                 0x51
            //   8b0d????????         |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   753a                 | jne                 0x3c
            //   33c9                 | xor                 ecx, ecx
            //   75fc                 | jne                 0xfffffffe

        $sequence_4 = { 0fb754415e 8b45ec 69c008040000 8b4d08 8d840160b10000 8b0c90 }
            // n = 6, score = 200
            //   0fb754415e           | movzx               edx, word ptr [ecx + eax*2 + 0x5e]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   69c008040000         | imul                eax, eax, 0x408
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d840160b10000       | lea                 eax, [ecx + eax + 0xb160]
            //   8b0c90               | mov                 ecx, dword ptr [eax + edx*4]

        $sequence_5 = { 8945f8 33d2 75fc 837df800 0f8cd6020000 33c0 75fc }
            // n = 7, score = 200
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   33d2                 | xor                 edx, edx
            //   75fc                 | jne                 0xfffffffe
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   0f8cd6020000         | jl                  0x2dc
            //   33c0                 | xor                 eax, eax
            //   75fc                 | jne                 0xfffffffe

        $sequence_6 = { 8b45fc 894220 8b4d08 c7410800000000 8b5508 c7420c00000000 8b4508 }
            // n = 7, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   894220               | mov                 dword ptr [edx + 0x20], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   c7410800000000       | mov                 dword ptr [ecx + 8], 0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   c7420c00000000       | mov                 dword ptr [edx + 0xc], 0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_7 = { 8b45b0 894415d0 b904000000 6bc900 }
            // n = 4, score = 200
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]
            //   894415d0             | mov                 dword ptr [ebp + edx - 0x30], eax
            //   b904000000           | mov                 ecx, 4
            //   6bc900               | imul                ecx, ecx, 0

        $sequence_8 = { c1e306 8b048590174300 0fbe441804 83e001 7470 57 }
            // n = 6, score = 200
            //   c1e306               | shl                 ebx, 6
            //   8b048590174300       | mov                 eax, dword ptr [eax*4 + 0x431790]
            //   0fbe441804           | movsx               eax, byte ptr [eax + ebx + 4]
            //   83e001               | and                 eax, 1
            //   7470                 | je                  0x72
            //   57                   | push                edi

        $sequence_9 = { 50 8b4d08 83c108 51 8b0d???????? e8???????? 8b08 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c108               | add                 ecx, 8
            //   51                   | push                ecx
            //   8b0d????????         |                     
            //   e8????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]

    condition:
        7 of them and filesize < 466944
}