rule win_albaniiutas_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.albaniiutas."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.albaniiutas"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 743a 8d45f4 50 6a01 ff75fc 6810660000 }
            // n = 6, score = 100
            //   743a                 | je                  0x3c
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   6810660000           | push                0x6610

        $sequence_1 = { ff75fc 6810660000 ff75f8 ff15???????? }
            // n = 4, score = 100
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   6810660000           | push                0x6610
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     

        $sequence_2 = { 40 c745ec48770010 894df8 8945fc 64a100000000 8945e8 8d45e8 }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   c745ec48770010       | mov                 dword ptr [ebp - 0x14], 0x10007748
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]

        $sequence_3 = { 83e03f c1f906 6bc030 03048d90df0210 50 }
            // n = 5, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bc030               | imul                eax, eax, 0x30
            //   03048d90df0210       | add                 eax, dword ptr [ecx*4 + 0x1002df90]
            //   50                   | push                eax

        $sequence_4 = { 83e63f c1ff06 6bf630 8b04bd90df0210 f644302880 741f e8???????? }
            // n = 7, score = 100
            //   83e63f               | and                 esi, 0x3f
            //   c1ff06               | sar                 edi, 6
            //   6bf630               | imul                esi, esi, 0x30
            //   8b04bd90df0210       | mov                 eax, dword ptr [edi*4 + 0x1002df90]
            //   f644302880           | test                byte ptr [eax + esi + 0x28], 0x80
            //   741f                 | je                  0x21
            //   e8????????           |                     

        $sequence_5 = { 83c418 8945d4 85c0 740f 8b4508 c74018241c0110 }
            // n = 6, score = 100
            //   83c418               | add                 esp, 0x18
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c74018241c0110       | mov                 dword ptr [eax + 0x18], 0x10011c24

        $sequence_6 = { 8d5b01 33c8 c1e808 81e1ff000000 33048dc01c0110 4f 75e5 }
            // n = 7, score = 100
            //   8d5b01               | lea                 ebx, [ebx + 1]
            //   33c8                 | xor                 ecx, eax
            //   c1e808               | shr                 eax, 8
            //   81e1ff000000         | and                 ecx, 0xff
            //   33048dc01c0110       | xor                 eax, dword ptr [ecx*4 + 0x10011cc0]
            //   4f                   | dec                 edi
            //   75e5                 | jne                 0xffffffe7

        $sequence_7 = { 83e805 7456 83e801 0f859b010000 c745e0e87c0110 8b4508 8bcf }
            // n = 7, score = 100
            //   83e805               | sub                 eax, 5
            //   7456                 | je                  0x58
            //   83e801               | sub                 eax, 1
            //   0f859b010000         | jne                 0x1a1
            //   c745e0e87c0110       | mov                 dword ptr [ebp - 0x20], 0x10017ce8
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bcf                 | mov                 ecx, edi

        $sequence_8 = { 3998c8a10110 0f84ea000000 41 83c030 894de4 }
            // n = 5, score = 100
            //   3998c8a10110         | cmp                 dword ptr [eax + 0x1001a1c8], ebx
            //   0f84ea000000         | je                  0xf0
            //   41                   | inc                 ecx
            //   83c030               | add                 eax, 0x30
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx

        $sequence_9 = { 331c85c0280110 335e08 8bcb 8bc3 }
            // n = 4, score = 100
            //   331c85c0280110       | xor                 ebx, dword ptr [eax*4 + 0x100128c0]
            //   335e08               | xor                 ebx, dword ptr [esi + 8]
            //   8bcb                 | mov                 ecx, ebx
            //   8bc3                 | mov                 eax, ebx

    condition:
        7 of them and filesize < 566272
}