rule win_alureon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.alureon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alureon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75f8 8b55ec 8b7de8 52 89530c 897b10 }
            // n = 6, score = 200
            //   75f8                 | jne                 0xfffffffa
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   52                   | push                edx
            //   89530c               | mov                 dword ptr [ebx + 0xc], edx
            //   897b10               | mov                 dword ptr [ebx + 0x10], edi

        $sequence_1 = { 8d4520 48 89442430 c744242814d00400 48 894c2420 }
            // n = 6, score = 200
            //   8d4520               | lea                 eax, [ebp + 0x20]
            //   48                   | dec                 eax
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   c744242814d00400     | mov                 dword ptr [esp + 0x28], 0x4d014
            //   48                   | dec                 eax
            //   894c2420             | mov                 dword ptr [esp + 0x20], ecx

        $sequence_2 = { 8bd0 8955fc 85d2 0f8451010000 32c0 8bce }
            // n = 6, score = 200
            //   8bd0                 | mov                 edx, eax
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   85d2                 | test                edx, edx
            //   0f8451010000         | je                  0x157
            //   32c0                 | xor                 al, al
            //   8bce                 | mov                 ecx, esi

        $sequence_3 = { 8d43d8 66894520 8bc1 44 894d2c c1e818 41 }
            // n = 7, score = 200
            //   8d43d8               | lea                 eax, [ebx - 0x28]
            //   66894520             | mov                 word ptr [ebp + 0x20], ax
            //   8bc1                 | mov                 eax, ecx
            //   44                   | inc                 esp
            //   894d2c               | mov                 dword ptr [ebp + 0x2c], ecx
            //   c1e818               | shr                 eax, 0x18
            //   41                   | inc                 ecx

        $sequence_4 = { 88442447 8d442424 50 6a60 }
            // n = 4, score = 200
            //   88442447             | mov                 byte ptr [esp + 0x47], al
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   6a60                 | push                0x60

        $sequence_5 = { 668945f4 8d45f0 50 6a01 }
            // n = 4, score = 200
            //   668945f4             | mov                 word ptr [ebp - 0xc], ax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_6 = { 48 81ecf0000000 48 8d6c2470 48 83e5e0 33c0 }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   81ecf0000000         | sub                 esp, 0xf0
            //   48                   | dec                 eax
            //   8d6c2470             | lea                 ebp, [esp + 0x70]
            //   48                   | dec                 eax
            //   83e5e0               | and                 ebp, 0xffffffe0
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { ff75f8 ff15???????? 85c0 7865 ff75b8 8d8598f9ffff 68???????? }
            // n = 7, score = 200
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7865                 | js                  0x67
            //   ff75b8               | push                dword ptr [ebp - 0x48]
            //   8d8598f9ffff         | lea                 eax, [ebp - 0x668]
            //   68????????           |                     

        $sequence_8 = { 50 8d85f8fcffff 68???????? 50 ffd6 83c418 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d85f8fcffff         | lea                 eax, [ebp - 0x308]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c418               | add                 esp, 0x18

        $sequence_9 = { c645f636 c645f71f c645f83d c645f929 c645fa3b c645fb00 e8???????? }
            // n = 7, score = 100
            //   c645f636             | mov                 byte ptr [ebp - 0xa], 0x36
            //   c645f71f             | mov                 byte ptr [ebp - 9], 0x1f
            //   c645f83d             | mov                 byte ptr [ebp - 8], 0x3d
            //   c645f929             | mov                 byte ptr [ebp - 7], 0x29
            //   c645fa3b             | mov                 byte ptr [ebp - 6], 0x3b
            //   c645fb00             | mov                 byte ptr [ebp - 5], 0
            //   e8????????           |                     

        $sequence_10 = { ab ab ab ab 8d442444 8944247c 53 }
            // n = 7, score = 100
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   8944247c             | mov                 dword ptr [esp + 0x7c], eax
            //   53                   | push                ebx

        $sequence_11 = { 53 57 8975f4 e8???????? 8b45f4 83c40c }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c40c               | add                 esp, 0xc

        $sequence_12 = { 74c5 395df8 7409 ff75f8 ff15???????? }
            // n = 5, score = 100
            //   74c5                 | je                  0xffffffc7
            //   395df8               | cmp                 dword ptr [ebp - 8], ebx
            //   7409                 | je                  0xb
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     

        $sequence_13 = { c645d002 c645d111 c645d23a c645d330 c645d401 }
            // n = 5, score = 100
            //   c645d002             | mov                 byte ptr [ebp - 0x30], 2
            //   c645d111             | mov                 byte ptr [ebp - 0x2f], 0x11
            //   c645d23a             | mov                 byte ptr [ebp - 0x2e], 0x3a
            //   c645d330             | mov                 byte ptr [ebp - 0x2d], 0x30
            //   c645d401             | mov                 byte ptr [ebp - 0x2c], 1

        $sequence_14 = { 75c5 56 ff15???????? 8a45ff 5e 5b c9 }
            // n = 7, score = 100
            //   75c5                 | jne                 0xffffffc7
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_15 = { 85c0 0f84f2020000 53 53 6a03 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f84f2020000         | je                  0x2f8
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a03                 | push                3

    condition:
        7 of them and filesize < 278528
}