rule win_antilam_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.antilam"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c9 8a8e07020000 0b148dd4964500 33c9 8a8e06020000 }
            // n = 5, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   8a8e07020000         | mov                 cl, byte ptr [esi + 0x207]
            //   0b148dd4964500       | or                  edx, dword ptr [ecx*4 + 0x4596d4]
            //   33c9                 | xor                 ecx, ecx
            //   8a8e06020000         | mov                 cl, byte ptr [esi + 0x206]

        $sequence_1 = { 33c0 8ac3 c680e0b6450001 33c0 5a 59 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8ac3                 | mov                 al, bl
            //   c680e0b6450001       | mov                 byte ptr [eax + 0x45b6e0], 1
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx

        $sequence_2 = { ff75f0 8d45e4 8a55eb e8???????? ff75e4 8bc3 33d2 }
            // n = 7, score = 100
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   8a55eb               | mov                 dl, byte ptr [ebp - 0x15]
            //   e8????????           |                     
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   8bc3                 | mov                 eax, ebx
            //   33d2                 | xor                 edx, edx

        $sequence_3 = { 8bd8 8d45c8 50 8bcb 49 ba01000000 8b45fc }
            // n = 7, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   50                   | push                eax
            //   8bcb                 | mov                 ecx, ebx
            //   49                   | dec                 ecx
            //   ba01000000           | mov                 edx, 1
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_4 = { 8d55ec e8???????? 8b45ec 8d55f0 e8???????? 8b45f0 ba???????? }
            // n = 7, score = 100
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   e8????????           |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   ba????????           |                     

        $sequence_5 = { 8bec 83c4f4 53 56 8955f8 8945fc 33c0 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83c4f4               | add                 esp, -0xc
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 8d55ec 8bc3 83e870 40 e8???????? }
            // n = 5, score = 100
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   8bc3                 | mov                 eax, ebx
            //   83e870               | sub                 eax, 0x70
            //   40                   | inc                 eax
            //   e8????????           |                     

        $sequence_7 = { b1ff 2ac8 8bc7 b2ff 2ad0 }
            // n = 5, score = 100
            //   b1ff                 | mov                 cl, 0xff
            //   2ac8                 | sub                 cl, al
            //   8bc7                 | mov                 eax, edi
            //   b2ff                 | mov                 dl, 0xff
            //   2ad0                 | sub                 dl, al

        $sequence_8 = { 8b4508 50 b8???????? ba01000000 e8???????? 59 eb75 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   b8????????           |                     
            //   ba01000000           | mov                 edx, 1
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   eb75                 | jmp                 0x77

        $sequence_9 = { 4e 85f6 7c3d 46 c745f800000000 ff33 8d4df0 }
            // n = 7, score = 100
            //   4e                   | dec                 esi
            //   85f6                 | test                esi, esi
            //   7c3d                 | jl                  0x3f
            //   46                   | inc                 esi
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   ff33                 | push                dword ptr [ebx]
            //   8d4df0               | lea                 ecx, [ebp - 0x10]

    condition:
        7 of them and filesize < 884736
}