rule win_artra_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.artra."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.artra"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b442410 5f 5e 83c41c c21000 5f 33c0 }
            // n = 7, score = 800
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   83c41c               | add                 esp, 0x1c
            //   c21000               | ret                 0x10
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 5f 8a08 40 84c9 75f9 2bc2 880c30 }
            // n = 7, score = 800
            //   5f                   | pop                 edi
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bc2                 | sub                 eax, edx
            //   880c30               | mov                 byte ptr [eax + esi], cl

        $sequence_2 = { 72e3 8bc6 8d5001 5f 8a08 40 }
            // n = 6, score = 800
            //   72e3                 | jb                  0xffffffe5
            //   8bc6                 | mov                 eax, esi
            //   8d5001               | lea                 edx, [eax + 1]
            //   5f                   | pop                 edi
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax

        $sequence_3 = { 84d2 75f9 2bc7 3bc8 72e3 8bc6 8d5001 }
            // n = 7, score = 800
            //   84d2                 | test                dl, dl
            //   75f9                 | jne                 0xfffffffb
            //   2bc7                 | sub                 eax, edi
            //   3bc8                 | cmp                 ecx, eax
            //   72e3                 | jb                  0xffffffe5
            //   8bc6                 | mov                 eax, esi
            //   8d5001               | lea                 edx, [eax + 1]

        $sequence_4 = { 51 8bc6 57 33c9 8d7801 8da42400000000 8a10 }
            // n = 7, score = 800
            //   51                   | push                ecx
            //   8bc6                 | mov                 eax, esi
            //   57                   | push                edi
            //   33c9                 | xor                 ecx, ecx
            //   8d7801               | lea                 edi, [eax + 1]
            //   8da42400000000       | lea                 esp, [esp]
            //   8a10                 | mov                 dl, byte ptr [eax]

        $sequence_5 = { 800431f3 8bc6 41 8d7801 }
            // n = 4, score = 800
            //   800431f3             | add                 byte ptr [ecx + esi], 0xf3
            //   8bc6                 | mov                 eax, esi
            //   41                   | inc                 ecx
            //   8d7801               | lea                 edi, [eax + 1]

        $sequence_6 = { c6042e00 e8???????? 8b542414 83c404 52 892d???????? 893d???????? }
            // n = 7, score = 600
            //   c6042e00             | mov                 byte ptr [esi + ebp], 0
            //   e8????????           |                     
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   83c404               | add                 esp, 4
            //   52                   | push                edx
            //   892d????????         |                     
            //   893d????????         |                     

        $sequence_7 = { 6a00 8d442414 50 ffd7 85c0 }
            // n = 5, score = 600
            //   6a00                 | push                0
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8d54241c 52 ffd7 85c0 75cc 5d 5b }
            // n = 7, score = 600
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   75cc                 | jne                 0xffffffce
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx

        $sequence_9 = { 55 8b2d???????? 90 8b542410 8d4c2410 }
            // n = 5, score = 600
            //   55                   | push                ebp
            //   8b2d????????         |                     
            //   90                   | nop                 
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   8d4c2410             | lea                 ecx, [esp + 0x10]

        $sequence_10 = { 85c0 7445 53 8b1d???????? 55 8b2d???????? }
            // n = 6, score = 600
            //   85c0                 | test                eax, eax
            //   7445                 | je                  0x47
            //   53                   | push                ebx
            //   8b1d????????         |                     
            //   55                   | push                ebp
            //   8b2d????????         |                     

        $sequence_11 = { 8bb424b0000000 33db 895c2408 85f6 0f84a9000000 391e 0f85a1000000 }
            // n = 7, score = 600
            //   8bb424b0000000       | mov                 esi, dword ptr [esp + 0xb0]
            //   33db                 | xor                 ebx, ebx
            //   895c2408             | mov                 dword ptr [esp + 8], ebx
            //   85f6                 | test                esi, esi
            //   0f84a9000000         | je                  0xaf
            //   391e                 | cmp                 dword ptr [esi], ebx
            //   0f85a1000000         | jne                 0xa7

        $sequence_12 = { e8???????? 8b4c242c 8b442418 8d542414 83fafc 7418 83f910 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   83fafc               | cmp                 edx, -4
            //   7418                 | je                  0x1a
            //   83f910               | cmp                 ecx, 0x10

        $sequence_13 = { 40 42 84c9 75f6 e8???????? }
            // n = 5, score = 600
            //   40                   | inc                 eax
            //   42                   | inc                 edx
            //   84c9                 | test                cl, cl
            //   75f6                 | jne                 0xfffffff8
            //   e8????????           |                     

        $sequence_14 = { 0f8488000000 6a00 57 ff15???????? 57 }
            // n = 5, score = 600
            //   0f8488000000         | je                  0x8e
            //   6a00                 | push                0
            //   57                   | push                edi
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_15 = { 2bc2 03fb 8a4f01 47 }
            // n = 4, score = 600
            //   2bc2                 | sub                 eax, edx
            //   03fb                 | add                 edi, ebx
            //   8a4f01               | mov                 cl, byte ptr [edi + 1]
            //   47                   | inc                 edi

        $sequence_16 = { ff15???????? 57 ff15???????? 6a6d 56 ff15???????? 8bf0 }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6a6d                 | push                0x6d
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_17 = { 8bf8 85ff 0f8488000000 6a00 }
            // n = 4, score = 600
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f8488000000         | je                  0x8e
            //   6a00                 | push                0

        $sequence_18 = { 51 c7442424ff030000 ff15???????? 8b542408 }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   c7442424ff030000     | mov                 dword ptr [esp + 0x24], 0x3ff
            //   ff15????????         |                     
            //   8b542408             | mov                 edx, dword ptr [esp + 8]

        $sequence_19 = { b8???????? c6042f00 8d5001 8da42400000000 8a08 }
            // n = 5, score = 400
            //   b8????????           |                     
            //   c6042f00             | mov                 byte ptr [edi + ebp], 0
            //   8d5001               | lea                 edx, [eax + 1]
            //   8da42400000000       | lea                 esp, [esp]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_20 = { c605????????00 b9???????? b8???????? 8a10 3a11 751a }
            // n = 6, score = 400
            //   c605????????00       |                     
            //   b9????????           |                     
            //   b8????????           |                     
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   3a11                 | cmp                 dl, byte ptr [ecx]
            //   751a                 | jne                 0x1c

        $sequence_21 = { 6a00 8d45f8 50 8d34fd4c114100 ff36 e8???????? 59 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d34fd4c114100       | lea                 esi, [edi*8 + 0x41114c]
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_22 = { 83e61f c1e606 033485e03b4100 8b45e4 }
            // n = 4, score = 400
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   033485e03b4100       | add                 esi, dword ptr [eax*4 + 0x413be0]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_23 = { ff15???????? 6a00 ff15???????? 5f 33c0 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax

        $sequence_24 = { 75f9 2bc2 8b542428 50 68???????? }
            // n = 5, score = 200
            //   75f9                 | jne                 0xfffffffb
            //   2bc2                 | sub                 eax, edx
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_25 = { 6a00 6a00 68???????? 6801000080 ff15???????? 8d4c2428 51 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   8d4c2428             | lea                 ecx, [esp + 0x28]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 811008
}