rule win_astralocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.astralocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.astralocker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 891401 89740104 b808000000 6bc800 8b5508 }
            // n = 5, score = 500
            //   891401               | mov                 dword ptr [ecx + eax], edx
            //   89740104             | mov                 dword ptr [ecx + eax + 4], esi
            //   b808000000           | mov                 eax, 8
            //   6bc800               | imul                ecx, eax, 0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_1 = { 51 e8???????? 83c408 8945ec 8955f0 }
            // n = 5, score = 500
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx

        $sequence_2 = { 50 8b0c0a 51 e8???????? 83c408 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   8b0c0a               | mov                 ecx, dword ptr [edx + ecx]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_3 = { 57 b808000000 6bc80a 8b5508 33c0 33f6 89040a }
            // n = 7, score = 500
            //   57                   | push                edi
            //   b808000000           | mov                 eax, 8
            //   6bc80a               | imul                ecx, eax, 0xa
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   33f6                 | xor                 esi, esi
            //   89040a               | mov                 dword ptr [edx + ecx], eax

        $sequence_4 = { ba08000000 6bc20a 8b4d08 33d2 }
            // n = 4, score = 500
            //   ba08000000           | mov                 edx, 8
            //   6bc20a               | imul                eax, edx, 0xa
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   33d2                 | xor                 edx, edx

        $sequence_5 = { 51 8b14d0 52 e8???????? 83c408 8945f4 8955f8 }
            // n = 7, score = 500
            //   51                   | push                ecx
            //   8b14d0               | mov                 edx, dword ptr [eax + edx*8]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

        $sequence_6 = { 6bc20a 8b4d08 33d2 33f6 891401 }
            // n = 5, score = 500
            //   6bc20a               | imul                eax, edx, 0xa
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   33d2                 | xor                 edx, edx
            //   33f6                 | xor                 esi, esi
            //   891401               | mov                 dword ptr [ecx + eax], edx

        $sequence_7 = { 8b4cd004 51 8b14d0 52 e8???????? 83c408 8945f4 }
            // n = 7, score = 500
            //   8b4cd004             | mov                 ecx, dword ptr [eax + edx*8 + 4]
            //   51                   | push                ecx
            //   8b14d0               | mov                 edx, dword ptr [eax + edx*8]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_8 = { b808000000 6bc80a 8b5508 33c0 33f6 89040a }
            // n = 6, score = 500
            //   b808000000           | mov                 eax, 8
            //   6bc80a               | imul                ecx, eax, 0xa
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   33f6                 | xor                 esi, esi
            //   89040a               | mov                 dword ptr [edx + ecx], eax

        $sequence_9 = { b808000000 6bc80a 8b5508 33c0 33f6 }
            // n = 5, score = 500
            //   b808000000           | mov                 eax, 8
            //   6bc80a               | imul                ecx, eax, 0xa
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   33f6                 | xor                 esi, esi

    condition:
        7 of them and filesize < 191488
}