rule win_ati_agent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ati_agent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ati_agent"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8d87000000 488d3d37af0000 ba58000000 488bcd e8???????? 4885c0 7468 }
            // n = 7, score = 100
            //   0f8d87000000         | add                 ebx, 8
            //   488d3d37af0000       | dec                 eax
            //   ba58000000           | lea                 ebx, [0x9d3e]
            //   488bcd               | mov                 esi, 0x40
            //   e8????????           |                     
            //   4885c0               | dec                 eax
            //   7468                 | mov                 edi, dword ptr [ebx]

        $sequence_1 = { 488bc8 ff15???????? 488d1548a20000 488bce }
            // n = 4, score = 100
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488d1548a20000       | cmp                 ebx, ecx
            //   488bce               | dec                 eax

        $sequence_2 = { 88441420 0fb6d1 4883fa13 72e8 488d542420 }
            // n = 5, score = 100
            //   88441420             | lea                 edx, [0xa1c1]
            //   0fb6d1               | dec                 eax
            //   4883fa13             | mov                 ecx, esi
            //   72e8                 | dec                 eax
            //   488d542420           | test                eax, eax

        $sequence_3 = { 80f90a 0f94c0 8944244c 488d052ec20000 4a8b14e0 41837c175000 }
            // n = 6, score = 100
            //   80f90a               | ret                 
            //   0f94c0               | dec                 eax
            //   8944244c             | sub                 esp, 0x28
            //   488d052ec20000       | dec                 eax
            //   4a8b14e0             | cmp                 ecx, -1
            //   41837c175000         | je                  0x33d

        $sequence_4 = { c3 83f914 7d0d 0fba72180f 83c110 e9???????? }
            // n = 6, score = 100
            //   c3                   | dec                 eax
            //   83f914               | lea                 edx, [esp + 0x20]
            //   7d0d                 | dec                 ecx
            //   0fba72180f           | mov                 ecx, ebx
            //   83c110               | mov                 byte ptr [esp + 0x33], 0
            //   e9????????           |                     

        $sequence_5 = { 4053 4883ec20 488bd9 488d0da07b0000 483bd9 }
            // n = 5, score = 100
            //   4053                 | arpl                cx, bx
            //   4883ec20             | dec                 eax
            //   488bd9               | lea                 edi, [0xa088]
            //   488d0da07b0000       | push                edi
            //   483bd9               | dec                 eax

        $sequence_6 = { 488d05247f0000 483bd8 7732 488bd3 }
            // n = 4, score = 100
            //   488d05247f0000       | jb                  0x1b3
            //   483bd8               | inc                 sp
            //   7732                 | mov                 dword ptr [esp + 0xea], ecx
            //   488bd3               | dec                 eax

        $sequence_7 = { 7409 8bc8 e8???????? ebc9 488bcb 488bc3 488d156ba30000 }
            // n = 7, score = 100
            //   7409                 | dec                 esp
            //   8bc8                 | mov                 dword ptr [ebp + 4], ebx
            //   e8????????           |                     
            //   ebc9                 | rep stosd           dword ptr es:[edi], eax
            //   488bcb               | dec                 eax
            //   488bc3               | lea                 edi, [0x5dce]
            //   488d156ba30000       | dec                 eax

        $sequence_8 = { 0fb6040a 342e 6633c1 48ffc1 664123c0 }
            // n = 5, score = 100
            //   0fb6040a             | lea                 eax, [0xc31e]
            //   342e                 | dec                 ecx
            //   6633c1               | sar                 esp, 5
            //   48ffc1               | dec                 esp
            //   664123c0             | lea                 eax, [0xffff8528]

        $sequence_9 = { 488d05247f0000 483bd8 7732 488bd3 48b8abaaaaaaaaaaaa2a }
            // n = 5, score = 100
            //   488d05247f0000       | je                  0xffffff0b
            //   483bd8               | dec                 eax
            //   7732                 | mov                 eax, dword ptr [ebp - 0x10]
            //   488bd3               | and                 dword ptr [eax + 0xc8], 0xfffffffd
            //   48b8abaaaaaaaaaaaa2a     | inc    eax

    condition:
        7 of them and filesize < 172032
}