rule win_atlas_agent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.atlas_agent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atlas_agent"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb60c0a 83e13c c1f902 03c1 }
            // n = 4, score = 200
            //   0fb60c0a             | movzx               ecx, byte ptr [edx + ecx]
            //   83e13c               | and                 ecx, 0x3c
            //   c1f902               | sar                 ecx, 2
            //   03c1                 | add                 eax, ecx

        $sequence_1 = { 8bc1 99 b903000000 f7f9 c1e002 }
            // n = 5, score = 200
            //   8bc1                 | mov                 eax, ecx
            //   99                   | cdq                 
            //   b903000000           | mov                 ecx, 3
            //   f7f9                 | idiv                ecx
            //   c1e002               | shl                 eax, 2

        $sequence_2 = { 4c8d0501c40200 488bd5 48c1fa06 4c893403 }
            // n = 4, score = 100
            //   4c8d0501c40200       | mov                 edi, eax
            //   488bd5               | mov                 ecx, 0x26e149f8
            //   48c1fa06             | dec                 eax
            //   4c893403             | add                 esp, 0x28

        $sequence_3 = { 89858cfdffff c745b47e000000 c745b83e000000 c745bc23000000 }
            // n = 4, score = 100
            //   89858cfdffff         | mov                 edi, eax
            //   c745b47e000000       | mov                 ecx, 0x1646c9fa
            //   c745b83e000000       | dec                 eax
            //   c745bc23000000       | add                 esp, 0x28

        $sequence_4 = { 89858cfbffff 6a00 6a00 8b8d8cfbffff e8???????? }
            // n = 5, score = 100
            //   89858cfbffff         | dec                 esp
            //   6a00                 | mov                 edi, eax
            //   6a00                 | mov                 ecx, 0x8426c3fa
            //   8b8d8cfbffff         | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { 898590f8ffff 8b9590f8ffff 89958cf8ffff c645fc06 }
            // n = 4, score = 100
            //   898590f8ffff         | dec                 eax
            //   8b9590f8ffff         | add                 esp, 0x28
            //   89958cf8ffff         | dec                 esp
            //   c645fc06             | mov                 edi, eax

        $sequence_6 = { 898590faffff 8b8d90faffff 51 8d8d60fbffff }
            // n = 4, score = 100
            //   898590faffff         | dec                 eax
            //   8b8d90faffff         | add                 esp, 0x28
            //   51                   | dec                 eax
            //   8d8d60fbffff         | mov                 ecx, dword ptr [esp + 8]

        $sequence_7 = { 898590feffff 68???????? 8b8590feffff 50 }
            // n = 4, score = 100
            //   898590feffff         | dec                 eax
            //   68????????           |                     
            //   8b8590feffff         | mov                 ecx, dword ptr [esp + 8]
            //   50                   | dec                 esp

        $sequence_8 = { 4c8bf8 b9ee4d81b7 e8???????? 4883c428 }
            // n = 4, score = 100
            //   4c8bf8               | dec                 esp
            //   b9ee4d81b7           | mov                 edi, eax
            //   e8????????           |                     
            //   4883c428             | mov                 ecx, 0xb7814dee

        $sequence_9 = { 4c8d0518650100 488bd0 488bce e8???????? }
            // n = 4, score = 100
            //   4c8d0518650100       | mov                 edi, eax
            //   488bd0               | mov                 ecx, 0xc2b42fa
            //   488bce               | dec                 eax
            //   e8????????           |                     

        $sequence_10 = { 4c8d050fcc0100 e8???????? 488bd3 8bcf }
            // n = 4, score = 100
            //   4c8d050fcc0100       | dec                 eax
            //   e8????????           |                     
            //   488bd3               | mov                 edx, dword ptr [esp + 0x10]
            //   8bcf                 | dec                 esp

        $sequence_11 = { 4c8d0517810100 e8???????? 4885c0 740d }
            // n = 4, score = 100
            //   4c8d0517810100       | dec                 eax
            //   e8????????           |                     
            //   4885c0               | mov                 edx, dword ptr [esp + 0x10]
            //   740d                 | dec                 esp

        $sequence_12 = { 89858cfdffff 8d8dc8fdffff e8???????? 8d8dc0fdffff }
            // n = 4, score = 100
            //   89858cfdffff         | mov                 ecx, dword ptr [esp + 8]
            //   8d8dc8fdffff         | dec                 eax
            //   e8????????           |                     
            //   8d8dc0fdffff         | mov                 edx, dword ptr [esp + 0x10]

        $sequence_13 = { 4c8d0516270200 488bc2 83e23f 48c1f806 }
            // n = 4, score = 100
            //   4c8d0516270200       | mov                 edi, eax
            //   488bc2               | mov                 ecx, 0xa473caf8
            //   83e23f               | dec                 eax
            //   48c1f806             | add                 esp, 0x28

    condition:
        7 of them and filesize < 857088
}