rule win_atmii_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.atmii."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atmii"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f6c302 740a 83481804 8a0a 884810 }
            // n = 5, score = 100
            //   f6c302               | test                bl, 2
            //   740a                 | je                  0xc
            //   83481804             | or                  dword ptr [eax + 0x18], 4
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   884810               | mov                 byte ptr [eax + 0x10], cl

        $sequence_1 = { 83c414 68???????? 50 68???????? 68???????? ffd7 8b4e10 }
            // n = 7, score = 100
            //   83c414               | add                 esp, 0x14
            //   68????????           |                     
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]

        $sequence_2 = { eb3e 84db 743a 8d4eb0 81f9a7000000 772f 0fb68920160010 }
            // n = 7, score = 100
            //   eb3e                 | jmp                 0x40
            //   84db                 | test                bl, bl
            //   743a                 | je                  0x3c
            //   8d4eb0               | lea                 ecx, [esi - 0x50]
            //   81f9a7000000         | cmp                 ecx, 0xa7
            //   772f                 | ja                  0x31
            //   0fb68920160010       | movzx               ecx, byte ptr [ecx + 0x10001620]

        $sequence_3 = { ffd6 83f803 0f85d8000000 8d85fcfdffff 50 }
            // n = 5, score = 100
            //   ffd6                 | call                esi
            //   83f803               | cmp                 eax, 3
            //   0f85d8000000         | jne                 0xde
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   50                   | push                eax

        $sequence_4 = { 8bec 81ec00040000 837d0803 0f8ceb000000 }
            // n = 4, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81ec00040000         | sub                 esp, 0x400
            //   837d0803             | cmp                 dword ptr [ebp + 8], 3
            //   0f8ceb000000         | jl                  0xf1

        $sequence_5 = { 83c420 8d9df8fcffff e8???????? 8b7508 c645ff01 eb27 50 }
            // n = 7, score = 100
            //   83c420               | add                 esp, 0x20
            //   8d9df8fcffff         | lea                 ebx, [ebp - 0x308]
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   c645ff01             | mov                 byte ptr [ebp - 1], 1
            //   eb27                 | jmp                 0x29
            //   50                   | push                eax

        $sequence_6 = { 8d8ddcfbffff 68???????? 51 ff15???????? 8d95dcfbffff 52 }
            // n = 6, score = 100
            //   8d8ddcfbffff         | lea                 ecx, [ebp - 0x424]
            //   68????????           |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d95dcfbffff         | lea                 edx, [ebp - 0x424]
            //   52                   | push                edx

        $sequence_7 = { c645ece9 3bca 760c 2bca }
            // n = 4, score = 100
            //   c645ece9             | mov                 byte ptr [ebp - 0x14], 0xe9
            //   3bca                 | cmp                 ecx, edx
            //   760c                 | jbe                 0xe
            //   2bca                 | sub                 ecx, edx

        $sequence_8 = { 740d 81481804010000 8a0a 884810 }
            // n = 4, score = 100
            //   740d                 | je                  0xf
            //   81481804010000       | or                  dword ptr [eax + 0x18], 0x104
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   884810               | mov                 byte ptr [eax + 0x10], cl

        $sequence_9 = { ffd3 68???????? 68???????? 8985c5f9ffff ffd7 }
            // n = 5, score = 100
            //   ffd3                 | call                ebx
            //   68????????           |                     
            //   68????????           |                     
            //   8985c5f9ffff         | mov                 dword ptr [ebp - 0x63b], eax
            //   ffd7                 | call                edi

        $sequence_10 = { 68???????? 51 ffd6 8d95fcf3ffff }
            // n = 4, score = 100
            //   68????????           |                     
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8d95fcf3ffff         | lea                 edx, [ebp - 0xc04]

        $sequence_11 = { 6a00 56 ffd7 8bd8 85db }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx

        $sequence_12 = { 8d8ddcfbffff 51 e8???????? 8b55fc }
            // n = 4, score = 100
            //   8d8ddcfbffff         | lea                 ecx, [ebp - 0x424]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_13 = { 83c444 6a00 6a00 6a03 }
            // n = 4, score = 100
            //   83c444               | add                 esp, 0x44
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a03                 | push                3

        $sequence_14 = { e8???????? 8b5608 8b3d???????? 83c414 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   8b3d????????         |                     
            //   83c414               | add                 esp, 0x14

        $sequence_15 = { 68???????? 8d95f8feffff 52 ffd6 0fb74306 }
            // n = 5, score = 100
            //   68????????           |                     
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   0fb74306             | movzx               eax, word ptr [ebx + 6]

    condition:
        7 of them and filesize < 49152
}