rule win_aurora_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.aurora."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aurora"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 8d4de4 c745d801000000 c745e0ffffffff }
            // n = 4, score = 300
            //   51                   | push                ecx
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   c745d801000000       | mov                 dword ptr [ebp - 0x28], 1
            //   c745e0ffffffff       | mov                 dword ptr [ebp - 0x20], 0xffffffff

        $sequence_1 = { 8855cc 33f6 8a55d2 8aca }
            // n = 4, score = 300
            //   8855cc               | mov                 byte ptr [ebp - 0x34], dl
            //   33f6                 | xor                 esi, esi
            //   8a55d2               | mov                 dl, byte ptr [ebp - 0x2e]
            //   8aca                 | mov                 cl, dl

        $sequence_2 = { 8d8dd4efffff c785e8efffff0f000000 c785e4efffff00000000 c685d4efffff00 e8???????? }
            // n = 5, score = 300
            //   8d8dd4efffff         | lea                 ecx, [ebp - 0x102c]
            //   c785e8efffff0f000000     | mov    dword ptr [ebp - 0x1018], 0xf
            //   c785e4efffff00000000     | mov    dword ptr [ebp - 0x101c], 0
            //   c685d4efffff00       | mov                 byte ptr [ebp - 0x102c], 0
            //   e8????????           |                     

        $sequence_3 = { 85c0 0f850affffff 85db 0f849b000000 8bc3 83fb04 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   0f850affffff         | jne                 0xffffff10
            //   85db                 | test                ebx, ebx
            //   0f849b000000         | je                  0xa1
            //   8bc3                 | mov                 eax, ebx
            //   83fb04               | cmp                 ebx, 4

        $sequence_4 = { 6a02 68???????? 8d8de4eeffff c785f8eeffff0f000000 c785f4eeffff00000000 c685e4eeffff00 e8???????? }
            // n = 7, score = 300
            //   6a02                 | push                2
            //   68????????           |                     
            //   8d8de4eeffff         | lea                 ecx, [ebp - 0x111c]
            //   c785f8eeffff0f000000     | mov    dword ptr [ebp - 0x1108], 0xf
            //   c785f4eeffff00000000     | mov    dword ptr [ebp - 0x110c], 0
            //   c685e4eeffff00       | mov                 byte ptr [ebp - 0x111c], 0
            //   e8????????           |                     

        $sequence_5 = { 68???????? 8d8de4f1ffff c785f8f1ffff0f000000 c785f4f1ffff00000000 c685e4f1ffff00 e8???????? }
            // n = 6, score = 300
            //   68????????           |                     
            //   8d8de4f1ffff         | lea                 ecx, [ebp - 0xe1c]
            //   c785f8f1ffff0f000000     | mov    dword ptr [ebp - 0xe08], 0xf
            //   c785f4f1ffff00000000     | mov    dword ptr [ebp - 0xe0c], 0
            //   c685e4f1ffff00       | mov                 byte ptr [ebp - 0xe1c], 0
            //   e8????????           |                     

        $sequence_6 = { c78550f1ffff0f000000 c7854cf1ffff00000000 c6853cf1ffff00 e8???????? 8d8d54f1ffff }
            // n = 5, score = 300
            //   c78550f1ffff0f000000     | mov    dword ptr [ebp - 0xeb0], 0xf
            //   c7854cf1ffff00000000     | mov    dword ptr [ebp - 0xeb4], 0
            //   c6853cf1ffff00       | mov                 byte ptr [ebp - 0xec4], 0
            //   e8????????           |                     
            //   8d8d54f1ffff         | lea                 ecx, [ebp - 0xeac]

        $sequence_7 = { e8???????? 6a04 68???????? 8d8d44efffff c78558efffff0f000000 c78554efffff00000000 c68544efffff00 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   6a04                 | push                4
            //   68????????           |                     
            //   8d8d44efffff         | lea                 ecx, [ebp - 0x10bc]
            //   c78558efffff0f000000     | mov    dword ptr [ebp - 0x10a8], 0xf
            //   c78554efffff00000000     | mov    dword ptr [ebp - 0x10ac], 0
            //   c68544efffff00       | mov                 byte ptr [ebp - 0x10bc], 0

        $sequence_8 = { e8???????? 8bd0 c745d407000000 33c0 c745d000000000 83c404 668945c0 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   c745d407000000       | mov                 dword ptr [ebp - 0x2c], 7
            //   33c0                 | xor                 eax, eax
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   83c404               | add                 esp, 4
            //   668945c0             | mov                 word ptr [ebp - 0x40], ax

        $sequence_9 = { 8b06 8b4804 8b44310c 85c0 0f9445f0 c745fc01000000 a806 }
            // n = 7, score = 300
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8b44310c             | mov                 eax, dword ptr [ecx + esi + 0xc]
            //   85c0                 | test                eax, eax
            //   0f9445f0             | sete                byte ptr [ebp - 0x10]
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   a806                 | test                al, 6

    condition:
        7 of them and filesize < 827392
}