rule win_babuk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.babuk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.babuk"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 6800000100 e8???????? 83c404 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   6800000100           | push                0x10000
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_1 = { 50 ff15???????? 83f803 7502 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83f803               | cmp                 eax, 3
            //   7502                 | jne                 4

        $sequence_2 = { e8???????? 83c408 8b4d18 8b5508 }
            // n = 4, score = 600
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_3 = { 8b0cca 51 e8???????? 83c408 8945f4 8955f8 }
            // n = 6, score = 600
            //   8b0cca               | mov                 ecx, dword ptr [edx + ecx*8]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

        $sequence_4 = { 83c002 8945fc 837dfc0a 0f83dc000000 8b4dfc }
            // n = 5, score = 600
            //   83c002               | add                 eax, 2
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc0a             | cmp                 dword ptr [ebp - 4], 0xa
            //   0f83dc000000         | jae                 0xe2
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_5 = { 89441104 ba08000000 6bc20a 8b4d08 c7040100000000 }
            // n = 5, score = 600
            //   89441104             | mov                 dword ptr [ecx + edx + 4], eax
            //   ba08000000           | mov                 edx, 8
            //   6bc20a               | imul                eax, edx, 0xa
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   c7040100000000       | mov                 dword ptr [ecx + eax], 0

        $sequence_6 = { 8b4d08 8b540104 52 8b0401 50 }
            // n = 5, score = 600
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b540104             | mov                 edx, dword ptr [ecx + eax + 4]
            //   52                   | push                edx
            //   8b0401               | mov                 eax, dword ptr [ecx + eax]
            //   50                   | push                eax

        $sequence_7 = { c7040100000000 c744010400000000 ba08000000 6bc200 8b4d08 }
            // n = 5, score = 600
            //   c7040100000000       | mov                 dword ptr [ecx + eax], 0
            //   c744010400000000     | mov                 dword ptr [ecx + eax + 4], 0
            //   ba08000000           | mov                 edx, 8
            //   6bc200               | imul                eax, edx, 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_8 = { 6a0a 6a06 6a02 8d45bc 50 }
            // n = 5, score = 600
            //   6a0a                 | push                0xa
            //   6a06                 | push                6
            //   6a02                 | push                2
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   50                   | push                eax

        $sequence_9 = { 68???????? 8b45ec 50 ff15???????? 8945f4 837df400 }
            // n = 6, score = 600
            //   68????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0

        $sequence_10 = { 8801 eba7 e9???????? 8b4dfc 33cd e8???????? }
            // n = 6, score = 600
            //   8801                 | mov                 byte ptr [ecx], al
            //   eba7                 | jmp                 0xffffffa9
            //   e9????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     

        $sequence_11 = { 50 8d4dac 51 8b55ac 52 8b45a4 50 }
            // n = 7, score = 600
            //   50                   | push                eax
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   51                   | push                ecx
            //   8b55ac               | mov                 edx, dword ptr [ebp - 0x54]
            //   52                   | push                edx
            //   8b45a4               | mov                 eax, dword ptr [ebp - 0x5c]
            //   50                   | push                eax

        $sequence_12 = { 0f84c6000000 6800800000 8b8de8fdffff 51 ff15???????? 8985e0fdffff 83bdecfdffff00 }
            // n = 7, score = 600
            //   0f84c6000000         | je                  0xcc
            //   6800800000           | push                0x8000
            //   8b8de8fdffff         | mov                 ecx, dword ptr [ebp - 0x218]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8985e0fdffff         | mov                 dword ptr [ebp - 0x220], eax
            //   83bdecfdffff00       | cmp                 dword ptr [ebp - 0x214], 0

        $sequence_13 = { 8b5508 8b44ca04 50 8b0cca }
            // n = 4, score = 600
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b44ca04             | mov                 eax, dword ptr [edx + ecx*8 + 4]
            //   50                   | push                eax
            //   8b0cca               | mov                 ecx, dword ptr [edx + ecx*8]

        $sequence_14 = { 8b5508 c7040a00000000 c7440a0400000000 c745fc00000000 eb09 }
            // n = 5, score = 600
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   c7040a00000000       | mov                 dword ptr [edx + ecx], 0
            //   c7440a0400000000     | mov                 dword ptr [edx + ecx + 4], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   eb09                 | jmp                 0xb

        $sequence_15 = { 6bf100 8b45ec 8b55f0 b11a e8???????? }
            // n = 5, score = 600
            //   6bf100               | imul                esi, ecx, 0
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   b11a                 | mov                 cl, 0x1a
            //   e8????????           |                     

    condition:
        7 of them and filesize < 183296
}