rule win_backbend_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.backbend."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.backbend"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8500ffffff 50 ff15???????? 85c0 7416 8d8500fbffff }
            // n = 6, score = 100
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   8d8500fbffff         | lea                 eax, [ebp - 0x500]

        $sequence_1 = { 6800020000 50 e8???????? 8d8500fbffff 53 }
            // n = 5, score = 100
            //   6800020000           | push                0x200
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8500fbffff         | lea                 eax, [ebp - 0x500]
            //   53                   | push                ebx

        $sequence_2 = { 81ec54020000 53 56 57 68???????? c605????????4b c605????????43 }
            // n = 7, score = 100
            //   81ec54020000         | sub                 esp, 0x254
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   68????????           |                     
            //   c605????????4b       |                     
            //   c605????????43       |                     

        $sequence_3 = { 68e8030000 ffd6 ff7510 ffd3 }
            // n = 4, score = 100
            //   68e8030000           | push                0x3e8
            //   ffd6                 | call                esi
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ffd3                 | call                ebx

        $sequence_4 = { ff15???????? 80a40500ffffff00 8d8500ffffff 56 50 ff15???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   80a40500ffffff00     | and                 byte ptr [ebp + eax - 0x100], 0
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_5 = { e8???????? 8d8500f9ffff 50 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8d8500f9ffff         | lea                 eax, [ebp - 0x700]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { e8???????? 68???????? 56 e8???????? 8d8500fdffff 56 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   8d8500fdffff         | lea                 eax, [ebp - 0x300]
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_7 = { 56 8bf8 ff15???????? 68???????? ff7508 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_8 = { e8???????? 8d8500f9ffff 56 50 e8???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8d8500f9ffff         | lea                 eax, [ebp - 0x700]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { 57 e8???????? 83c410 6860ea0000 ffd6 33c0 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   6860ea0000           | push                0xea60
            //   ffd6                 | call                esi
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 49152
}