rule win_backconfig_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.backconfig."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.backconfig"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a1???????? 8b0d???????? 8b15???????? 8985f0feffff a1???????? 6a51 8985fcfeffff }
            // n = 7, score = 100
            //   a1????????           |                     
            //   8b0d????????         |                     
            //   8b15????????         |                     
            //   8985f0feffff         | mov                 dword ptr [ebp - 0x110], eax
            //   a1????????           |                     
            //   6a51                 | push                0x51
            //   8985fcfeffff         | mov                 dword ptr [ebp - 0x104], eax

        $sequence_1 = { e8???????? 8b4de4 83c40c 6bc930 8975e0 8db1682a4100 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   83c40c               | add                 esp, 0xc
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8db1682a4100         | lea                 esi, [ecx + 0x412a68]

        $sequence_2 = { 8a15???????? 8d8569ffffff 6a00 50 898d64ffffff 889568ffffff }
            // n = 6, score = 100
            //   8a15????????         |                     
            //   8d8569ffffff         | lea                 eax, [ebp - 0x97]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   898d64ffffff         | mov                 dword ptr [ebp - 0x9c], ecx
            //   889568ffffff         | mov                 byte ptr [ebp - 0x98], dl

        $sequence_3 = { c1f805 8d1485c0504100 8b0a 83e61f c1e606 03ce }
            // n = 6, score = 100
            //   c1f805               | sar                 eax, 5
            //   8d1485c0504100       | lea                 edx, [eax*4 + 0x4150c0]
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   03ce                 | add                 ecx, esi

        $sequence_4 = { 8bc3 c1f805 8d3c85c0504100 8bf3 83e61f c1e606 8b07 }
            // n = 7, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   c1f805               | sar                 eax, 5
            //   8d3c85c0504100       | lea                 edi, [eax*4 + 0x4150c0]
            //   8bf3                 | mov                 esi, ebx
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_5 = { 8b0d???????? 8b15???????? 8985f0feffff a1???????? 6a51 8985fcfeffff 898df4feffff }
            // n = 7, score = 100
            //   8b0d????????         |                     
            //   8b15????????         |                     
            //   8985f0feffff         | mov                 dword ptr [ebp - 0x110], eax
            //   a1????????           |                     
            //   6a51                 | push                0x51
            //   8985fcfeffff         | mov                 dword ptr [ebp - 0x104], eax
            //   898df4feffff         | mov                 dword ptr [ebp - 0x10c], ecx

        $sequence_6 = { 8d8d2cfdffff 68???????? 51 e8???????? 83c414 68401f0000 }
            // n = 6, score = 100
            //   8d8d2cfdffff         | lea                 ecx, [ebp - 0x2d4]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   68401f0000           | push                0x1f40

        $sequence_7 = { 6a00 50 898d64ffffff 889568ffffff e8???????? }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   898d64ffffff         | mov                 dword ptr [ebp - 0x9c], ecx
            //   889568ffffff         | mov                 byte ptr [ebp - 0x98], dl
            //   e8????????           |                     

        $sequence_8 = { 8bf1 83e61f 8d3c85c0504100 8b07 c1e606 f644300401 7436 }
            // n = 7, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   83e61f               | and                 esi, 0x1f
            //   8d3c85c0504100       | lea                 edi, [eax*4 + 0x4150c0]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   c1e606               | shl                 esi, 6
            //   f644300401           | test                byte ptr [eax + esi + 4], 1
            //   7436                 | je                  0x38

        $sequence_9 = { 8bec 8b4508 56 8d34c550224100 833e00 7513 }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   8d34c550224100       | lea                 esi, [eax*8 + 0x412250]
            //   833e00               | cmp                 dword ptr [esi], 0
            //   7513                 | jne                 0x15

    condition:
        7 of them and filesize < 217088
}