rule win_badcall_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.badcall."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badcall"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 85c0 75d3 5f 33c0 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   75d3                 | jne                 0xffffffd5
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 6a06 6a01 6a02 c744241801000000 8944241c }
            // n = 5, score = 300
            //   6a06                 | push                6
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   c744241801000000     | mov                 dword ptr [esp + 0x18], 1
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax

        $sequence_2 = { 89442412 8bf1 6685ff 66c74424080000 6689442416 746d }
            // n = 6, score = 300
            //   89442412             | mov                 dword ptr [esp + 0x12], eax
            //   8bf1                 | mov                 esi, ecx
            //   6685ff               | test                di, di
            //   66c74424080000       | mov                 word ptr [esp + 8], 0
            //   6689442416           | mov                 word ptr [esp + 0x16], ax
            //   746d                 | je                  0x6f

        $sequence_3 = { 8b44241c 6685c0 7442 33d2 50 }
            // n = 5, score = 300
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   6685c0               | test                ax, ax
            //   7442                 | je                  0x44
            //   33d2                 | xor                 edx, edx
            //   50                   | push                eax

        $sequence_4 = { 83f8ff 7453 8d4c2404 6a04 }
            // n = 4, score = 300
            //   83f8ff               | cmp                 eax, -1
            //   7453                 | je                  0x55
            //   8d4c2404             | lea                 ecx, [esp + 4]
            //   6a04                 | push                4

        $sequence_5 = { 50 8954240a 66c74424080200 8954240e 894c240c 89542412 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   8954240a             | mov                 dword ptr [esp + 0xa], edx
            //   66c74424080200       | mov                 word ptr [esp + 8], 2
            //   8954240e             | mov                 dword ptr [esp + 0xe], edx
            //   894c240c             | mov                 dword ptr [esp + 0xc], ecx
            //   89542412             | mov                 dword ptr [esp + 0x12], edx

        $sequence_6 = { 8d7c240d c644240c00 f3ab 66ab 8d4c242c }
            // n = 5, score = 300
            //   8d7c240d             | lea                 edi, [esp + 0xd]
            //   c644240c00           | mov                 byte ptr [esp + 0xc], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]

        $sequence_7 = { 8a4c2408 8a542420 3aca 7509 66817c24090103 7402 33c0 }
            // n = 7, score = 300
            //   8a4c2408             | mov                 cl, byte ptr [esp + 8]
            //   8a542420             | mov                 dl, byte ptr [esp + 0x20]
            //   3aca                 | cmp                 cl, dl
            //   7509                 | jne                 0xb
            //   66817c24090103       | cmp                 word ptr [esp + 9], 0x301
            //   7402                 | je                  4
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 8be8 bfffff0000 83c404 3bef }
            // n = 4, score = 200
            //   8be8                 | mov                 ebp, eax
            //   bfffff0000           | mov                 edi, 0xffff
            //   83c404               | add                 esp, 4
            //   3bef                 | cmp                 ebp, edi

        $sequence_9 = { c644242bb3 896c2418 ffd7 8bd8 8d442414 }
            // n = 5, score = 200
            //   c644242bb3           | mov                 byte ptr [esp + 0x2b], 0xb3
            //   896c2418             | mov                 dword ptr [esp + 0x18], ebp
            //   ffd7                 | call                edi
            //   8bd8                 | mov                 ebx, eax
            //   8d442414             | lea                 eax, [esp + 0x14]

        $sequence_10 = { 57 8b7c241c 83ff01 741b 83ff02 }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   83ff01               | cmp                 edi, 1
            //   741b                 | je                  0x1d
            //   83ff02               | cmp                 edi, 2

        $sequence_11 = { 2bf9 895500 8d5504 8bc1 8bf7 }
            // n = 5, score = 200
            //   2bf9                 | sub                 edi, ecx
            //   895500               | mov                 dword ptr [ebp], edx
            //   8d5504               | lea                 edx, [ebp + 4]
            //   8bc1                 | mov                 eax, ecx
            //   8bf7                 | mov                 esi, edi

        $sequence_12 = { 55 ff15???????? 8bf8 83ffff 7512 5f }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83ffff               | cmp                 edi, -1
            //   7512                 | jne                 0x14
            //   5f                   | pop                 edi

        $sequence_13 = { 81c408020000 c3 8d842414010000 6803010000 50 }
            // n = 5, score = 200
            //   81c408020000         | add                 esp, 0x208
            //   c3                   | ret                 
            //   8d842414010000       | lea                 eax, [esp + 0x114]
            //   6803010000           | push                0x103
            //   50                   | push                eax

        $sequence_14 = { 2bd1 8b4c2418 03c2 51 894608 }
            // n = 5, score = 200
            //   2bd1                 | sub                 edx, ecx
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   03c2                 | add                 eax, edx
            //   51                   | push                ecx
            //   894608               | mov                 dword ptr [esi + 8], eax

        $sequence_15 = { 895604 8b16 8bc7 2bc2 8b542418 }
            // n = 5, score = 200
            //   895604               | mov                 dword ptr [esi + 4], edx
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8bc7                 | mov                 eax, edi
            //   2bc2                 | sub                 eax, edx
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]

        $sequence_16 = { 0f8484000000 85c0 7473 8d442418 50 56 ff15???????? }
            // n = 7, score = 100
            //   0f8484000000         | je                  0x8a
            //   85c0                 | test                eax, eax
            //   7473                 | je                  0x75
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_17 = { 8d442410 6a04 50 53 e8???????? }
            // n = 5, score = 100
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   6a04                 | push                4
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_18 = { 6a01 53 6689842486000000 ff15???????? }
            // n = 4, score = 100
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   6689842486000000     | mov                 word ptr [esp + 0x86], ax
            //   ff15????????         |                     

        $sequence_19 = { c3 8bc8 83e01f c1f905 8d04c0 8b0c8de0ad0110 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   8bc8                 | mov                 ecx, eax
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   8b0c8de0ad0110       | mov                 ecx, dword ptr [ecx*4 + 0x1001ade0]

        $sequence_20 = { 83c102 03c7 4a 75f3 8b542440 }
            // n = 5, score = 100
            //   83c102               | add                 ecx, 2
            //   03c7                 | add                 eax, edi
            //   4a                   | dec                 edx
            //   75f3                 | jne                 0xfffffff5
            //   8b542440             | mov                 edx, dword ptr [esp + 0x40]

        $sequence_21 = { 7520 42 3bd1 7d1f 8a441410 }
            // n = 5, score = 100
            //   7520                 | jne                 0x22
            //   42                   | inc                 edx
            //   3bd1                 | cmp                 edx, ecx
            //   7d1f                 | jge                 0x21
            //   8a441410             | mov                 al, byte ptr [esp + edx + 0x10]

        $sequence_22 = { ffd6 8d7c240c 83c9ff 33c0 33d2 f2ae }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   8d7c240c             | lea                 edi, [esp + 0xc]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_23 = { 83e01f c1f905 8d34c0 8b048de0ad0110 }
            // n = 4, score = 100
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8d34c0               | lea                 esi, [eax + eax*8]
            //   8b048de0ad0110       | mov                 eax, dword ptr [ecx*4 + 0x1001ade0]

    condition:
        7 of them and filesize < 483328
}