rule win_badencript_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.badencript."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badencript"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 23c1 eb55 8b1c9d68d14000 56 6800080000 }
            // n = 5, score = 100
            //   23c1                 | and                 eax, ecx
            //   eb55                 | jmp                 0x57
            //   8b1c9d68d14000       | mov                 ebx, dword ptr [ebx*4 + 0x40d168]
            //   56                   | push                esi
            //   6800080000           | push                0x800

        $sequence_1 = { 8b0c8d48414100 c644112800 85f6 740c }
            // n = 4, score = 100
            //   8b0c8d48414100       | mov                 ecx, dword ptr [ecx*4 + 0x414148]
            //   c644112800           | mov                 byte ptr [ecx + edx + 0x28], 0
            //   85f6                 | test                esi, esi
            //   740c                 | je                  0xe

        $sequence_2 = { 660fd60f 8d7f08 8b048d04b54000 ffe0 }
            // n = 4, score = 100
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048d04b54000       | mov                 eax, dword ptr [ecx*4 + 0x40b504]
            //   ffe0                 | jmp                 eax

        $sequence_3 = { 57 8d1c85383d4100 33c0 f00fb10b 8b15???????? 83cfff }
            // n = 6, score = 100
            //   57                   | push                edi
            //   8d1c85383d4100       | lea                 ebx, [eax*4 + 0x413d38]
            //   33c0                 | xor                 eax, eax
            //   f00fb10b             | lock cmpxchg        dword ptr [ebx], ecx
            //   8b15????????         |                     
            //   83cfff               | or                  edi, 0xffffffff

        $sequence_4 = { 7451 83e809 7443 83e801 0f8501010000 c745e0a40f4100 }
            // n = 6, score = 100
            //   7451                 | je                  0x53
            //   83e809               | sub                 eax, 9
            //   7443                 | je                  0x45
            //   83e801               | sub                 eax, 1
            //   0f8501010000         | jne                 0x107
            //   c745e0a40f4100       | mov                 dword ptr [ebp - 0x20], 0x410fa4

        $sequence_5 = { 660fd60f 8d7f08 8b048d04b54000 ffe0 f7c703000000 7413 }
            // n = 6, score = 100
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048d04b54000       | mov                 eax, dword ptr [ecx*4 + 0x40b504]
            //   ffe0                 | jmp                 eax
            //   f7c703000000         | test                edi, 3
            //   7413                 | je                  0x15

        $sequence_6 = { c1fa06 6bc830 8b049548414100 f644082801 7414 8d4508 8945fc }
            // n = 7, score = 100
            //   c1fa06               | sar                 edx, 6
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b049548414100       | mov                 eax, dword ptr [edx*4 + 0x414148]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7414                 | je                  0x16
            //   8d4508               | lea                 eax, [ebp + 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_7 = { 6bc830 8b049548414100 f644082801 7421 57 e8???????? }
            // n = 6, score = 100
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b049548414100       | mov                 eax, dword ptr [edx*4 + 0x414148]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7421                 | je                  0x23
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_8 = { 83e03f c1fa06 6bc830 8b049548414100 f644082801 7414 }
            // n = 6, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   c1fa06               | sar                 edx, 6
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b049548414100       | mov                 eax, dword ptr [edx*4 + 0x414148]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7414                 | je                  0x16

        $sequence_9 = { 7313 8a8750304100 08441619 42 }
            // n = 4, score = 100
            //   7313                 | jae                 0x15
            //   8a8750304100         | mov                 al, byte ptr [edi + 0x413050]
            //   08441619             | or                  byte ptr [esi + edx + 0x19], al
            //   42                   | inc                 edx

    condition:
        7 of them and filesize < 335872
}