rule win_bagle_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bagle."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bagle"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a02 6a00 ff75fc e8???????? 0bc0 }
            // n = 5, score = 300
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax

        $sequence_1 = { 75e2 c3 55 8bec 56 8b4508 }
            // n = 6, score = 300
            //   75e2                 | jne                 0xffffffe4
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_2 = { 6a02 e8???????? 8bd8 ff7508 e8???????? 83fbff }
            // n = 6, score = 300
            //   6a02                 | push                2
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83fbff               | cmp                 ebx, -1

        $sequence_3 = { 5e c9 c20c00 c1c206 8bc2 243f }
            // n = 6, score = 300
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   c1c206               | rol                 edx, 6
            //   8bc2                 | mov                 eax, edx
            //   243f                 | and                 al, 0x3f

        $sequence_4 = { 8b4d10 33db e340 ac }
            // n = 4, score = 300
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   33db                 | xor                 ebx, ebx
            //   e340                 | jecxz               0x42
            //   ac                   | lodsb               al, byte ptr [esi]

        $sequence_5 = { 6a00 6a00 6a00 ff7508 e8???????? 6a00 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_6 = { 79c6 f7d9 2bf9 b03d }
            // n = 4, score = 300
            //   79c6                 | jns                 0xffffffc8
            //   f7d9                 | neg                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   b03d                 | mov                 al, 0x3d

        $sequence_7 = { 6880000000 68???????? e8???????? 6a00 6a00 6a00 68???????? }
            // n = 7, score = 300
            //   6880000000           | push                0x80
            //   68????????           |                     
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     

    condition:
        7 of them and filesize < 245760
}