rule win_bandit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bandit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bandit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b542448 488bb424c0000000 488bbc2480000000 4c8b842448010000 4939f8 7f1a 4c8b8c2430010000 }
            // n = 7, score = 100
            //   488b542448           | mov                 byte ptr [esp + 5], ch
            //   488bb424c0000000     | inc                 esp
            //   488bbc2480000000     | movzx               ebp, byte ptr [esp + 0x23]
            //   4c8b842448010000     | mov                 byte ptr [esp + 0xf], al
            //   4939f8               | inc                 esp
            //   7f1a                 | movzx               ebp, byte ptr [esp + 0x18]
            //   4c8b8c2430010000     | inc                 esp

        $sequence_1 = { eb02 31d2 4889442438 48895c2428 84d2 7407 b901000000 }
            // n = 7, score = 100
            //   eb02                 | nop                 dword ptr [eax]
            //   31d2                 | test                dl, dl
            //   4889442438           | jne                 0x2078
            //   48895c2428           | dec                 eax
            //   84d2                 | mov                 edx, 0x9dbc3346
            //   7407                 | push                cs
            //   b901000000           | not                 byte ptr [ebx - 0x75]

        $sequence_2 = { e9???????? 49c7417000000000 b801000000 488bac2438010000 4881c440010000 c3 31c0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   49c7417000000000     | dec                 esp
            //   b801000000           | mov                 edi, dword ptr [esp + 0x88]
            //   488bac2438010000     | nop                 dword ptr [eax]
            //   4881c440010000       | dec                 ecx
            //   c3                   | cmp                 edi, 0x14
            //   31c0                 | dec                 esp

        $sequence_3 = { 4d89c8 4c894c2468 488d1582b94e00 e8???????? 4c8b4c2468 c78424b400000001000000 c78424a000000001000000 }
            // n = 7, score = 100
            //   4d89c8               | dec                 eax
            //   4c894c2468           | add                 esp, 0x130
            //   488d1582b94e00       | ret                 
            //   e8????????           |                     
            //   4c8b4c2468           | dec                 ebp
            //   c78424b400000001000000     | mov    esp, edi
            //   c78424a000000001000000     | dec    ecx

        $sequence_4 = { 749b 440f11bc24c0000000 440f11bc24d0000000 488b9424f8000000 48899424c0000000 488bb42400010000 4889b424c8000000 }
            // n = 7, score = 100
            //   749b                 | ret                 
            //   440f11bc24c0000000     | xor    eax, eax
            //   440f11bc24d0000000     | xor    ebx, ebx
            //   488b9424f8000000     | dec                 eax
            //   48899424c0000000     | mov                 ebp, dword ptr [esp + 0x20]
            //   488bb42400010000     | dec                 eax
            //   4889b424c8000000     | lea                 eax, [0x9c477b]

        $sequence_5 = { 4d8d0cf3 4d8d49d8 833d????????00 7525 4c8b4c2458 4d894cf3d8 498d34f3 }
            // n = 7, score = 100
            //   4d8d0cf3             | mov                 esi, dword ptr [eax + 0xf0]
            //   4d8d49d8             | dec                 eax
            //   833d????????00       |                     
            //   7525                 | test                edx, edx
            //   4c8b4c2458           | jne                 0x337
            //   4d894cf3d8           | nop                 
            //   498d34f3             | dec                 eax

        $sequence_6 = { 488b6c2430 4883c438 c3 488d0555df9400 488b6c2430 4883c438 c3 }
            // n = 7, score = 100
            //   488b6c2430           | mov                 edx, dword ptr [esp + 0x20]
            //   4883c438             | inc                 edx
            //   c3                   | lea                 edi, [edx + edx]
            //   488d0555df9400       | dec                 eax
            //   488b6c2430           | mov                 edx, dword ptr [esp + 0x48]
            //   4883c438             | dec                 eax
            //   c3                   | mov                 esi, dword ptr [esp + 0x38]

        $sequence_7 = { 4c89a424b8000000 488b9424b0000000 4885d2 7426 440fb66a17 4589ef 4183e51f }
            // n = 7, score = 100
            //   4c89a424b8000000     | mov                 eax, edx
            //   488b9424b0000000     | dec                 eax
            //   4885d2               | mov                 edx, ecx
            //   7426                 | dec                 esp
            //   440fb66a17           | mov                 ebx, edx
            //   4589ef               | dec                 eax
            //   4183e51f             | mov                 ebp, dword ptr [esp + 0x10]

        $sequence_8 = { e8???????? 4889442440 48895c2448 48894c2450 c644242700 488b542458 488b02 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889442440           | jbe                 0x1429
            //   48895c2448           | inc                 esp
            //   48894c2450           | mov                 dword ptr [esi + edx], eax
            //   c644242700           | dec                 esp
            //   488b542458           | mov                 dword ptr [esp + 0x240], eax
            //   488b02               | dec                 eax

        $sequence_9 = { 7404 488b4008 e8???????? 90 e8???????? 8b44242c 488b6c2458 }
            // n = 7, score = 100
            //   7404                 | dec                 eax
            //   488b4008             | mov                 dword ptr [esp + 0xb8], edi
            //   e8????????           |                     
            //   90                   | dec                 esp
            //   e8????????           |                     
            //   8b44242c             | mov                 esp, dword ptr [esp + 0x50]
            //   488b6c2458           | dec                 ebp

    condition:
        7 of them and filesize < 29914112
}