rule win_batchwiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.batchwiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.batchwiper"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a1???????? 50 50 ff742408 e8???????? 8d0d2cb14000 5a }
            // n = 7, score = 100
            //   a1????????           |                     
            //   50                   | push                eax
            //   50                   | push                eax
            //   ff742408             | push                dword ptr [esp + 8]
            //   e8????????           |                     
            //   8d0d2cb14000         | lea                 ecx, [0x40b12c]
            //   5a                   | pop                 edx

        $sequence_1 = { 8d0d24b14000 5a e8???????? c744240c02000000 }
            // n = 4, score = 100
            //   8d0d24b14000         | lea                 ecx, [0x40b124]
            //   5a                   | pop                 edx
            //   e8????????           |                     
            //   c744240c02000000     | mov                 dword ptr [esp + 0xc], 2

        $sequence_2 = { a1???????? 50 50 ff35???????? ff35???????? e8???????? 8d0d9cb14000 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   50                   | push                eax
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8d0d9cb14000         | lea                 ecx, [0x40b19c]

        $sequence_3 = { 8d0d44b14000 e8???????? ba???????? 8d0d48b14000 e8???????? ba???????? 8d0d4cb14000 }
            // n = 7, score = 100
            //   8d0d44b14000         | lea                 ecx, [0x40b144]
            //   e8????????           |                     
            //   ba????????           |                     
            //   8d0d48b14000         | lea                 ecx, [0x40b148]
            //   e8????????           |                     
            //   ba????????           |                     
            //   8d0d4cb14000         | lea                 ecx, [0x40b14c]

        $sequence_4 = { ff96e0de0100 09c0 7407 8903 }
            // n = 4, score = 100
            //   ff96e0de0100         | call                dword ptr [esi + 0x1dee0]
            //   09c0                 | or                  eax, eax
            //   7407                 | je                  9
            //   8903                 | mov                 dword ptr [ebx], eax

        $sequence_5 = { e8???????? a3???????? 8b1d???????? 21db 7e65 c705????????00000000 8b1d???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   a3????????           |                     
            //   8b1d????????         |                     
            //   21db                 | and                 ebx, ebx
            //   7e65                 | jle                 0x67
            //   c705????????00000000     |     
            //   8b1d????????         |                     

        $sequence_6 = { e8???????? ba???????? 8d0d60b14000 e8???????? ba???????? 8d0d64b14000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ba????????           |                     
            //   8d0d60b14000         | lea                 ecx, [0x40b160]
            //   e8????????           |                     
            //   ba????????           |                     
            //   8d0d64b14000         | lea                 ecx, [0x40b164]
            //   e8????????           |                     

        $sequence_7 = { 893d???????? c705????????dd424000 c705????????80464000 c705????????da464000 }
            // n = 4, score = 100
            //   893d????????         |                     
            //   c705????????dd424000     |     
            //   c705????????80464000     |     
            //   c705????????da464000     |     

        $sequence_8 = { 8b442408 894514 8b442404 894518 }
            // n = 4, score = 100
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   894514               | mov                 dword ptr [ebp + 0x14], eax
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   894518               | mov                 dword ptr [ebp + 0x18], eax

        $sequence_9 = { 46 46 53 686d490100 57 }
            // n = 5, score = 100
            //   46                   | inc                 esi
            //   46                   | inc                 esi
            //   53                   | push                ebx
            //   686d490100           | push                0x1496d
            //   57                   | push                edi

    condition:
        7 of them and filesize < 270336
}