rule win_biodata_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.biodata"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45f0 50 83c9ff ba???????? }
            // n = 4, score = 200
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   83c9ff               | or                  ecx, 0xffffffff
            //   ba????????           |                     

        $sequence_1 = { a1???????? e8???????? 8b1424 898288000000 8b0424 8b5368 899080000000 }
            // n = 7, score = 200
            //   a1????????           |                     
            //   e8????????           |                     
            //   8b1424               | mov                 edx, dword ptr [esp]
            //   898288000000         | mov                 dword ptr [edx + 0x88], eax
            //   8b0424               | mov                 eax, dword ptr [esp]
            //   8b5368               | mov                 edx, dword ptr [ebx + 0x68]
            //   899080000000         | mov                 dword ptr [eax + 0x80], edx

        $sequence_2 = { 8d4500 fe8d4500fa8d 45 00d7 8d4500 }
            // n = 5, score = 200
            //   8d4500               | lea                 eax, [ebp]
            //   fe8d4500fa8d         | dec                 byte ptr [ebp - 0x7205ffbb]
            //   45                   | inc                 ebp
            //   00d7                 | add                 bh, dl
            //   8d4500               | lea                 eax, [ebp]

        $sequence_3 = { 8bd8 8bc3 e8???????? 8bc3 e8???????? 83b88400000000 746b }
            // n = 7, score = 200
            //   8bd8                 | mov                 ebx, eax
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   83b88400000000       | cmp                 dword ptr [eax + 0x84], 0
            //   746b                 | je                  0x6d

        $sequence_4 = { 8bd0 8bc3 8b08 ff5118 8bf8 8b5618 8bc7 }
            // n = 7, score = 200
            //   8bd0                 | mov                 edx, eax
            //   8bc3                 | mov                 eax, ebx
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5118               | call                dword ptr [ecx + 0x18]
            //   8bf8                 | mov                 edi, eax
            //   8b5618               | mov                 edx, dword ptr [esi + 0x18]
            //   8bc7                 | mov                 eax, edi

        $sequence_5 = { 8b4320 e8???????? 85c0 7e42 f645ff01 743c }
            // n = 6, score = 200
            //   8b4320               | mov                 eax, dword ptr [ebx + 0x20]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7e42                 | jle                 0x44
            //   f645ff01             | test                byte ptr [ebp - 1], 1
            //   743c                 | je                  0x3e

        $sequence_6 = { 33d2 8b45fc 8b08 ff5138 8b06 50 }
            // n = 6, score = 200
            //   33d2                 | xor                 edx, edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5138               | call                dword ptr [ecx + 0x38]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   50                   | push                eax

        $sequence_7 = { 8b30 ff5648 8bc3 8b10 ff5254 84c0 0f84e2010000 }
            // n = 7, score = 200
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   ff5648               | call                dword ptr [esi + 0x48]
            //   8bc3                 | mov                 eax, ebx
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff5254               | call                dword ptr [edx + 0x54]
            //   84c0                 | test                al, al
            //   0f84e2010000         | je                  0x1e8

        $sequence_8 = { a1???????? 8b00 e8???????? 33c9 33d2 a1???????? e8???????? }
            // n = 7, score = 200
            //   a1????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   33d2                 | xor                 edx, edx
            //   a1????????           |                     
            //   e8????????           |                     

        $sequence_9 = { a1???????? e8???????? 89870c010000 8bce 33d2 8bc7 e8???????? }
            // n = 7, score = 200
            //   a1????????           |                     
            //   e8????????           |                     
            //   89870c010000         | mov                 dword ptr [edi + 0x10c], eax
            //   8bce                 | mov                 ecx, esi
            //   33d2                 | xor                 edx, edx
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1589248
}