rule win_bitter_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bitter_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bitter_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 898558d9ffff 8b8558d9ffff }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   898558d9ffff         | mov                 dword ptr [ebp - 0x26a8], eax
            //   8b8558d9ffff         | mov                 eax, dword ptr [ebp - 0x26a8]

        $sequence_1 = { 50 68???????? e8???????? 83c40c 8b45f8 83c002 8945f8 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83c002               | add                 eax, 2
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_2 = { 8bf4 8d853cecffff 50 ff15???????? 3bf4 e8???????? 52 }
            // n = 7, score = 200
            //   8bf4                 | mov                 esi, esp
            //   8d853cecffff         | lea                 eax, [ebp - 0x13c4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   52                   | push                edx

        $sequence_3 = { 40 ff05???????? f7460c0c010000 754e 53 57 8d3c8518104700 }
            // n = 7, score = 200
            //   40                   | inc                 eax
            //   ff05????????         |                     
            //   f7460c0c010000       | test                dword ptr [esi + 0xc], 0x10c
            //   754e                 | jne                 0x50
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8d3c8518104700       | lea                 edi, [eax*4 + 0x471018]

        $sequence_4 = { 57 8d3c8500124700 8b07 83e61f }
            // n = 4, score = 200
            //   57                   | push                edi
            //   8d3c8500124700       | lea                 edi, [eax*4 + 0x471200]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   83e61f               | and                 esi, 0x1f

        $sequence_5 = { ff15???????? 3bf4 e8???????? 8985e0fbffff e8???????? 0fb6852bfcffff 85c0 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   8985e0fbffff         | mov                 dword ptr [ebp - 0x420], eax
            //   e8????????           |                     
            //   0fb6852bfcffff       | movzx               eax, byte ptr [ebp - 0x3d5]
            //   85c0                 | test                eax, eax

        $sequence_6 = { 8dbdf4fdffff b983000000 b8cccccccc f3ab }
            // n = 4, score = 200
            //   8dbdf4fdffff         | lea                 edi, [ebp - 0x20c]
            //   b983000000           | mov                 ecx, 0x83
            //   b8cccccccc           | mov                 eax, 0xcccccccc
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_7 = { 8d8dccd8ffff 51 6a01 8d95d8d8ffff 52 a1???????? 50 }
            // n = 7, score = 200
            //   8d8dccd8ffff         | lea                 ecx, [ebp - 0x2734]
            //   51                   | push                ecx
            //   6a01                 | push                1
            //   8d95d8d8ffff         | lea                 edx, [ebp - 0x2728]
            //   52                   | push                edx
            //   a1????????           |                     
            //   50                   | push                eax

        $sequence_8 = { 83c40c 8bf4 6804010000 68???????? 6a00 }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   8bf4                 | mov                 esi, esp
            //   6804010000           | push                0x104
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_9 = { 53 56 57 8dbd94dbffff b91b090000 b8cccccccc }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8dbd94dbffff         | lea                 edi, [ebp - 0x246c]
            //   b91b090000           | mov                 ecx, 0x91b
            //   b8cccccccc           | mov                 eax, 0xcccccccc

    condition:
        7 of them and filesize < 1130496
}