rule win_blackenergy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.blackenergy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackenergy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 ffd7 8b4508 8b7df0 }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   ffd7                 | call                edi
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]

        $sequence_1 = { 895dec 895df8 895df0 e8???????? 8b0d???????? }
            // n = 5, score = 200
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   e8????????           |                     
            //   8b0d????????         |                     

        $sequence_2 = { 894dac 81f900c00000 0f862a020000 b809000000 81f900000100 0f860f010000 }
            // n = 6, score = 200
            //   894dac               | mov                 dword ptr [ebp - 0x54], ecx
            //   81f900c00000         | cmp                 ecx, 0xc000
            //   0f862a020000         | jbe                 0x230
            //   b809000000           | mov                 eax, 9
            //   81f900000100         | cmp                 ecx, 0x10000
            //   0f860f010000         | jbe                 0x115

        $sequence_3 = { 8b07 83c014 50 8d45f4 }
            // n = 4, score = 200
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   83c014               | add                 eax, 0x14
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_4 = { 66c745f86500 e8???????? c9 c3 55 }
            // n = 5, score = 200
            //   66c745f86500         | mov                 word ptr [ebp - 8], 0x65
            //   e8????????           |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_5 = { 8b4e14 3bd1 7602 8bca 394d08 7339 8b4d08 }
            // n = 7, score = 200
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   3bd1                 | cmp                 edx, ecx
            //   7602                 | jbe                 4
            //   8bca                 | mov                 ecx, edx
            //   394d08               | cmp                 dword ptr [ebp + 8], ecx
            //   7339                 | jae                 0x3b
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_6 = { 742a 3bc2 7426 895028 395120 }
            // n = 5, score = 200
            //   742a                 | je                  0x2c
            //   3bc2                 | cmp                 eax, edx
            //   7426                 | je                  0x28
            //   895028               | mov                 dword ptr [eax + 0x28], edx
            //   395120               | cmp                 dword ptr [ecx + 0x20], edx

        $sequence_7 = { ff75f4 6801000080 ffd0 85c0 }
            // n = 4, score = 200
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6801000080           | push                0x80000001
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8bec 83ec10 8b0b 8b4508 8365f800 2bc1 83e804 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   2bc1                 | sub                 eax, ecx
            //   83e804               | sub                 eax, 4

        $sequence_9 = { 83ec48 6a04 8d45fc 50 8d45e8 50 8d45b8 }
            // n = 7, score = 200
            //   83ec48               | sub                 esp, 0x48
            //   6a04                 | push                4
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   8d45b8               | lea                 eax, [ebp - 0x48]

    condition:
        7 of them and filesize < 98304
}