rule win_blacknix_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blacknix_rat"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { bb???????? 33c0 55 68???????? 64ff30 648920 b8???????? }
            // n = 7, score = 100
            //   bb????????           |                     
            //   33c0                 | xor                 eax, eax
            //   55                   | push                ebp
            //   68????????           |                     
            //   64ff30               | push                dword ptr fs:[eax]
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   b8????????           |                     

        $sequence_1 = { ff4c2408 0f8522ffffff 8bc6 e8???????? 8b542404 8b08 ff5148 }
            // n = 7, score = 100
            //   ff4c2408             | dec                 dword ptr [esp + 8]
            //   0f8522ffffff         | jne                 0xffffff28
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5148               | call                dword ptr [ecx + 0x48]

        $sequence_2 = { d9e0 83c4fc d91c24 9b 8d8578ffffff e8???????? 8b8578ffffff }
            // n = 7, score = 100
            //   d9e0                 | fchs                
            //   83c4fc               | add                 esp, -4
            //   d91c24               | fstp                dword ptr [esp]
            //   9b                   | wait                
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   e8????????           |                     
            //   8b8578ffffff         | mov                 eax, dword ptr [ebp - 0x88]

        $sequence_3 = { ff7514 ff7510 8d45ec e8???????? 8d55ec 8d4df7 8bc3 }
            // n = 7, score = 100
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   e8????????           |                     
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   8d4df7               | lea                 ecx, [ebp - 9]
            //   8bc3                 | mov                 eax, ebx

        $sequence_4 = { be???????? 8d7dbc b909000000 f3a5 8d55bc 8b45fc 8b8014020000 }
            // n = 7, score = 100
            //   be????????           |                     
            //   8d7dbc               | lea                 edi, [ebp - 0x44]
            //   b909000000           | mov                 ecx, 9
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8d55bc               | lea                 edx, [ebp - 0x44]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b8014020000         | mov                 eax, dword ptr [eax + 0x214]

        $sequence_5 = { b901000000 8b15???????? e8???????? 83c404 8d55c8 8bc3 e8???????? }
            // n = 7, score = 100
            //   b901000000           | mov                 ecx, 1
            //   8b15????????         |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d55c8               | lea                 edx, [ebp - 0x38]
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     

        $sequence_6 = { e8???????? 8bf0 89b3d8020000 8bc6 8b15???????? e8???????? 89580c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   89b3d8020000         | mov                 dword ptr [ebx + 0x2d8], esi
            //   8bc6                 | mov                 eax, esi
            //   8b15????????         |                     
            //   e8????????           |                     
            //   89580c               | mov                 dword ptr [eax + 0xc], ebx

        $sequence_7 = { d98690010000 d825???????? e8???????? 8bc8 b201 a1???????? e8???????? }
            // n = 7, score = 100
            //   d98690010000         | fld                 dword ptr [esi + 0x190]
            //   d825????????         |                     
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   b201                 | mov                 dl, 1
            //   a1????????           |                     
            //   e8????????           |                     

        $sequence_8 = { e8???????? 8a0d???????? 5a 8b18 ff5360 8b0424 8b8070020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8a0d????????         |                     
            //   5a                   | pop                 edx
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff5360               | call                dword ptr [ebx + 0x60]
            //   8b0424               | mov                 eax, dword ptr [esp]
            //   8b8070020000         | mov                 eax, dword ptr [eax + 0x270]

        $sequence_9 = { c78090020000c4994a00 8bce b201 a1???????? e8???????? 8bd8 899ea8020000 }
            // n = 7, score = 100
            //   c78090020000c4994a00     | mov    dword ptr [eax + 0x290], 0x4a99c4
            //   8bce                 | mov                 ecx, esi
            //   b201                 | mov                 dl, 1
            //   a1????????           |                     
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   899ea8020000         | mov                 dword ptr [esi + 0x2a8], ebx

    condition:
        7 of them and filesize < 3252224
}