rule win_blackruby_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-05-30"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.4.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackruby"
        malpedia_rule_date = "20200529"
        malpedia_hash = "92c362319514e5a6da26204961446caa3a8b32a8"
        malpedia_version = "20200529"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 20c6 5b 15e7272f1b 2b57d7 f33c95 3b4aa8 19614a }
            // n = 7, score = 200
            //   20c6                 | and                 dh, al
            //   5b                   | pop                 ebx
            //   15e7272f1b           | adc                 eax, 0x1b2f27e7
            //   2b57d7               | sub                 edx, dword ptr [edi - 0x29]
            //   f33c95               | cmp                 al, 0x95
            //   3b4aa8               | cmp                 ecx, dword ptr [edx - 0x58]
            //   19614a               | sbb                 dword ptr [ecx + 0x4a], esp

        $sequence_1 = { 0da20a2719 93 35cf24166b 15ef94144a 0a9a2e5306bb 283a }
            // n = 6, score = 200
            //   0da20a2719           | or                  eax, 0x19270aa2
            //   93                   | xchg                eax, ebx
            //   35cf24166b           | xor                 eax, 0x6b1624cf
            //   15ef94144a           | adc                 eax, 0x4a1494ef
            //   0a9a2e5306bb         | or                  bl, byte ptr [edx - 0x44f9acd2]
            //   283a                 | sub                 byte ptr [edx], bh

        $sequence_2 = { 5b 2021 af 4d 5d }
            // n = 5, score = 200
            //   5b                   | pop                 ebx
            //   2021                 | and                 byte ptr [ecx], ah
            //   af                   | scasd               eax, dword ptr es:[edi]
            //   4d                   | dec                 ebp
            //   5d                   | pop                 ebp

        $sequence_3 = { d9a56a7feb04 8b755b 1137 d80c94 6e 623a }
            // n = 6, score = 200
            //   d9a56a7feb04         | fldenv              [ebp + 0x4eb7f6a]
            //   8b755b               | mov                 esi, dword ptr [ebp + 0x5b]
            //   1137                 | adc                 dword ptr [edi], esi
            //   d80c94               | fmul                dword ptr [esp + edx*4]
            //   6e                   | outsb               dx, byte ptr [esi]
            //   623a                 | bound               edi, qword ptr [edx]

        $sequence_4 = { 0a20 207f2c 203d???????? 3c42 }
            // n = 4, score = 200
            //   0a20                 | or                  ah, byte ptr [eax]
            //   207f2c               | and                 byte ptr [edi + 0x2c], bh
            //   203d????????         |                     
            //   3c42                 | cmp                 al, 0x42

        $sequence_5 = { 4c 2504038be8 9e 7c07 }
            // n = 4, score = 200
            //   4c                   | dec                 esp
            //   2504038be8           | and                 eax, 0xe88b0304
            //   9e                   | sahf                
            //   7c07                 | jl                  9

        $sequence_6 = { 0a9a2e5306bb 283a 194535 98 4c da36 }
            // n = 6, score = 200
            //   0a9a2e5306bb         | or                  bl, byte ptr [edx - 0x44f9acd2]
            //   283a                 | sub                 byte ptr [edx], bh
            //   194535               | sbb                 dword ptr [ebp + 0x35], eax
            //   98                   | cwde                
            //   4c                   | dec                 esp
            //   da36                 | fidiv               dword ptr [esi]

        $sequence_7 = { de11 0b5213 49 f32e61 6e }
            // n = 5, score = 200
            //   de11                 | ficom               word ptr [ecx]
            //   0b5213               | or                  edx, dword ptr [edx + 0x13]
            //   49                   | dec                 ecx
            //   f32e61               | popal               
            //   6e                   | outsb               dx, byte ptr [esi]

        $sequence_8 = { 40 46 20e9 4f }
            // n = 4, score = 200
            //   40                   | inc                 eax
            //   46                   | inc                 esi
            //   20e9                 | and                 cl, ch
            //   4f                   | dec                 edi

        $sequence_9 = { 4c 52 4e 41 4c }
            // n = 5, score = 200
            //   4c                   | dec                 esp
            //   52                   | push                edx
            //   4e                   | dec                 esi
            //   41                   | inc                 ecx
            //   4c                   | dec                 esp

    condition:
        7 of them and filesize < 1040384
}