rule win_bluelight_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bluelight."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bluelight"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff722c 8b5104 8d4d98 897588 e8???????? 89458c 83c410 }
            // n = 7, score = 100
            //   ff722c               | push                dword ptr [edx + 0x2c]
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   897588               | mov                 dword ptr [ebp - 0x78], esi
            //   e8????????           |                     
            //   89458c               | mov                 dword ptr [ebp - 0x74], eax
            //   83c410               | add                 esp, 0x10

        $sequence_1 = { f6433804 7403 83e0c3 0fb74f1a 0fb77718 898d4cffffff 0fb74f1c }
            // n = 7, score = 100
            //   f6433804             | test                byte ptr [ebx + 0x38], 4
            //   7403                 | je                  5
            //   83e0c3               | and                 eax, 0xffffffc3
            //   0fb74f1a             | movzx               ecx, word ptr [edi + 0x1a]
            //   0fb77718             | movzx               esi, word ptr [edi + 0x18]
            //   898d4cffffff         | mov                 dword ptr [ebp - 0xb4], ecx
            //   0fb74f1c             | movzx               ecx, word ptr [edi + 0x1c]

        $sequence_2 = { f77720 40 3bf0 74e3 8b7dec 8b45f0 8975f8 }
            // n = 7, score = 100
            //   f77720               | div                 dword ptr [edi + 0x20]
            //   40                   | inc                 eax
            //   3bf0                 | cmp                 esi, eax
            //   74e3                 | je                  0xffffffe5
            //   8b7dec               | mov                 edi, dword ptr [ebp - 0x14]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8975f8               | mov                 dword ptr [ebp - 8], esi

        $sequence_3 = { ff7508 ff701c 6a25 5a e8???????? 83c40c 8945d4 }
            // n = 7, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff701c               | push                dword ptr [eax + 0x1c]
            //   6a25                 | push                0x25
            //   5a                   | pop                 edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax

        $sequence_4 = { 68???????? 53 e8???????? 8b55ec 83c424 85d2 7407 }
            // n = 7, score = 100
            //   68????????           |                     
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   83c424               | add                 esp, 0x24
            //   85d2                 | test                edx, edx
            //   7407                 | je                  9

        $sequence_5 = { f3a5 eb23 ff742420 68???????? eb92 8d4101 8bcb }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   eb23                 | jmp                 0x25
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   68????????           |                     
            //   eb92                 | jmp                 0xffffff94
            //   8d4101               | lea                 eax, [ecx + 1]
            //   8bcb                 | mov                 ecx, ebx

        $sequence_6 = { e8???????? 8bd3 895da8 3955c4 0f8e24130000 8b45c8 8b4004 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bd3                 | mov                 edx, ebx
            //   895da8               | mov                 dword ptr [ebp - 0x58], ebx
            //   3955c4               | cmp                 dword ptr [ebp - 0x3c], edx
            //   0f8e24130000         | jle                 0x132a
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_7 = { e8???????? 8bd7 8bce e8???????? fe4b12 8d742418 6a14 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bd7                 | mov                 edx, edi
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   fe4b12               | dec                 byte ptr [ebx + 0x12]
            //   8d742418             | lea                 esi, [esp + 0x18]
            //   6a14                 | push                0x14

        $sequence_8 = { ff4140 5b 8be5 5d c3 55 8bec }
            // n = 7, score = 100
            //   ff4140               | inc                 dword ptr [ecx + 0x40]
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_9 = { eb26 f7462400400000 7421 8b4620 85c0 741a 8b5010 }
            // n = 7, score = 100
            //   eb26                 | jmp                 0x28
            //   f7462400400000       | test                dword ptr [esi + 0x24], 0x4000
            //   7421                 | je                  0x23
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   85c0                 | test                eax, eax
            //   741a                 | je                  0x1c
            //   8b5010               | mov                 edx, dword ptr [eax + 0x10]

    condition:
        7 of them and filesize < 2191360
}