rule win_bootwreck_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bootwreck."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bootwreck"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 d558 6e 82c178 0e 2a5cce35 45 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   d558                 | aad                 0x58
            //   6e                   | outsb               dx, byte ptr [esi]
            //   82c178               | add                 cl, 0x78
            //   0e                   | push                cs
            //   2a5cce35             | sub                 bl, byte ptr [esi + ecx*8 + 0x35]
            //   45                   | inc                 ebp

        $sequence_1 = { e9???????? ff3424 6802f2412c 9c 876c2444 9c 681ef2f505 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   ff3424               | push                dword ptr [esp]
            //   6802f2412c           | push                0x2c41f202
            //   9c                   | pushfd              
            //   876c2444             | xchg                dword ptr [esp + 0x44], ebp
            //   9c                   | pushfd              
            //   681ef2f505           | push                0x5f5f21e

        $sequence_2 = { 6a02 e8???????? 33db 3bc3 7412 ffd0 0fb7c0 }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   3bc3                 | cmp                 eax, ebx
            //   7412                 | je                  0x14
            //   ffd0                 | call                eax
            //   0fb7c0               | movzx               eax, ax

        $sequence_3 = { 660fb3c7 89c7 f9 f8 f5 84f0 83c404 }
            // n = 7, score = 100
            //   660fb3c7             | btr                 di, ax
            //   89c7                 | mov                 edi, eax
            //   f9                   | stc                 
            //   f8                   | clc                 
            //   f5                   | cmc                 
            //   84f0                 | test                al, dh
            //   83c404               | add                 esp, 4

        $sequence_4 = { bed27fe028 a4 ab 5b 6212 672c13 1abaeb624f13 }
            // n = 7, score = 100
            //   bed27fe028           | mov                 esi, 0x28e07fd2
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   5b                   | pop                 ebx
            //   6212                 | bound               edx, qword ptr [edx]
            //   672c13               | sub                 al, 0x13
            //   1abaeb624f13         | sbb                 bh, byte ptr [edx + 0x134f62eb]

        $sequence_5 = { 90 e8???????? 89442408 9c 660fb6c2 660fbec2 0f9ac4 }
            // n = 7, score = 100
            //   90                   | nop                 
            //   e8????????           |                     
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   9c                   | pushfd              
            //   660fb6c2             | movzx               ax, dl
            //   660fbec2             | movsx               ax, dl
            //   0f9ac4               | setp                ah

        $sequence_6 = { 85c0 881424 9c 60 66c70424320b 8d64242c 0f84e23a0300 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   881424               | mov                 byte ptr [esp], dl
            //   9c                   | pushfd              
            //   60                   | pushal              
            //   66c70424320b         | mov                 word ptr [esp], 0xb32
            //   8d64242c             | lea                 esp, [esp + 0x2c]
            //   0f84e23a0300         | je                  0x33ae8

        $sequence_7 = { 25ffffff7f 66c1eb0d 6687f3 80f72b 60 0345fc 8d642444 }
            // n = 7, score = 100
            //   25ffffff7f           | and                 eax, 0x7fffffff
            //   66c1eb0d             | shr                 bx, 0xd
            //   6687f3               | xchg                bx, si
            //   80f72b               | xor                 bh, 0x2b
            //   60                   | pushal              
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   8d642444             | lea                 esp, [esp + 0x44]

        $sequence_8 = { c6442414c9 c6442408a4 ff742430 c23400 ff3424 895e24 9c }
            // n = 7, score = 100
            //   c6442414c9           | mov                 byte ptr [esp + 0x14], 0xc9
            //   c6442408a4           | mov                 byte ptr [esp + 8], 0xa4
            //   ff742430             | push                dword ptr [esp + 0x30]
            //   c23400               | ret                 0x34
            //   ff3424               | push                dword ptr [esp]
            //   895e24               | mov                 dword ptr [esi + 0x24], ebx
            //   9c                   | pushfd              

        $sequence_9 = { 70af 9c 236202 3376ad 9add1461e82b4a 97 1e }
            // n = 7, score = 100
            //   70af                 | jo                  0xffffffb1
            //   9c                   | pushfd              
            //   236202               | and                 esp, dword ptr [edx + 2]
            //   3376ad               | xor                 esi, dword ptr [esi - 0x53]
            //   9add1461e82b4a       | lcall               0x4a2b:0xe86114dd
            //   97                   | xchg                eax, edi
            //   1e                   | push                ds

    condition:
        7 of them and filesize < 10821632
}