rule win_bottomloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bottomloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bottomloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 418bcd e8???????? 807c24700a 4c8d15fe0b0400 74bb 41b80d000000 448803 }
            // n = 7, score = 100
            //   418bcd               | lea                 ecx, [ebp - 0xa0]
            //   e8????????           |                     
            //   807c24700a           | dec                 eax
            //   4c8d15fe0b0400       | lea                 ecx, [0x383a3]
            //   74bb                 | dec                 eax
            //   41b80d000000         | mov                 dword ptr [ebp - 0x88], ecx
            //   448803               | dec                 eax

        $sequence_1 = { 41c6460642 41c6460756 41c6460855 41c646096b 41c6460a77 41c6460b39 41c6460c49 }
            // n = 7, score = 100
            //   41c6460642           | je                  0x909
            //   41c6460756           | dec                 esp
            //   41c6460855           | mov                 ecx, eax
            //   41c646096b           | dec                 eax
            //   41c6460a77           | mov                 edx, dword ptr [ecx + eax*8]
            //   41c6460b39           | mov                 ebx, 0xad8
            //   41c6460c49           | dec                 eax

        $sequence_2 = { c705????????090400c0 c705????????01000000 c705????????01000000 b808000000 486bc000 488d0d3a7e0300 48c7040102000000 }
            // n = 7, score = 100
            //   c705????????090400c0     |     
            //   c705????????01000000     |     
            //   c705????????01000000     |     
            //   b808000000           | xor                 esp, esp
            //   486bc000             | dec                 esp
            //   488d0d3a7e0300       | lea                 ebp, [0xa0825]
            //   48c7040102000000     | inc                 ebp

        $sequence_3 = { e8???????? 488945e0 488955e8 488d5de0 48899dd0feffff 488d3d03120900 48897df8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488945e0             | inc                 esp
            //   488955e8             | mov                 dword ptr [ebp + 0x20], eax
            //   488d5de0             | inc                 esp
            //   48899dd0feffff       | mov                 eax, dword ptr [ebp + 0x20]
            //   488d3d03120900       | mov                 edx, dword ptr [ebp + 0x18]
            //   48897df8             | mov                 ecx, dword ptr [ebp + 0x10]

        $sequence_4 = { 488d8db0fcffff e8???????? 488d3d4f520900 4889bdf8fcffff 48c785f0fcffff0e000000 488d8df0fcffff e8???????? }
            // n = 7, score = 100
            //   488d8db0fcffff       | mov                 esi, dword ptr [ebp - 0x50]
            //   e8????????           |                     
            //   488d3d4f520900       | dec                 eax
            //   4889bdf8fcffff       | mov                 edi, dword ptr [ebp - 0x48]
            //   48c785f0fcffff0e000000     | mov    ebx, dword ptr [ebp + 0x18]
            //   488d8df0fcffff       | cmp                 dword ptr [ebp + 0x10], ebx
            //   e8????????           |                     

        $sequence_5 = { 48bae0b1ffff0f270000 488d4df0 e8???????? 48bae0b1ffff0f270000 488d4df0 e8???????? 85c0 }
            // n = 7, score = 100
            //   48bae0b1ffff0f270000     | dec    eax
            //   488d4df0             | test                eax, eax
            //   e8????????           |                     
            //   48bae0b1ffff0f270000     | je    0xb41
            //   488d4df0             | mov                 ecx, 3
            //   e8????????           |                     
            //   85c0                 | dec                 eax

        $sequence_6 = { 894d10 895518 44894520 4d89cd 488b5d30 488d35fae40400 488dbd10ffffff }
            // n = 7, score = 100
            //   894d10               | inc                 ebx
            //   895518               | movzx               esi, byte ptr [edx + eax]
            //   44894520             | jmp                 0xff9
            //   4d89cd               | inc                 ebp
            //   488b5d30             | xor                 eax, eax
            //   488d35fae40400       | mov                 edx, 0x143
            //   488dbd10ffffff       | dec                 eax

        $sequence_7 = { 488b5208 4889d3 09c3 747b 48898570ffffff 48899578ffffff 488d3d19440a00 }
            // n = 7, score = 100
            //   488b5208             | inc                 esp
            //   4889d3               | mov                 ecx, dword ptr [esi]
            //   09c3                 | dec                 esp
            //   747b                 | lea                 eax, [0x448d0]
            //   48898570ffffff       | mov                 edx, 0xf
            //   48899578ffffff       | dec                 eax
            //   488d3d19440a00       | lea                 ecx, [ebp - 0x50]

        $sequence_8 = { e9???????? 48897da0 4c8d150ab70600 4c8955d8 48c745d00f000000 4c8d4dd0 440fbf06 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   48897da0             | test                ebx, ebx
            //   4c8d150ab70600       | je                  0x23a
            //   4c8955d8             | dec                 eax
            //   48c745d00f000000     | lea                 ecx, [0x53888]
            //   4c8d4dd0             | dec                 esp
            //   440fbf06             | mov                 eax, dword ptr [ebp - 0x248]

        $sequence_9 = { e8???????? 4c8d0dee830700 4c898d78fcffff 48c78570fcffff0e000000 488d8d70fcffff e8???????? 488d05c9830700 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d0dee830700       | dec                 esp
            //   4c898d78fcffff       | mov                 eax, dword ptr [ebp + 0x10]
            //   48c78570fcffff0e000000     | dec    eax
            //   488d8d70fcffff       | sub                 esp, 0x60
            //   e8????????           |                     
            //   488d05c9830700       | dec                 eax

    condition:
        7 of them and filesize < 1955840
}