rule win_buterat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.buterat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.buterat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff750c 8d8564ffffff 50 56 8d5de8 e8???????? 83c414 }
            // n = 7, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8d8564ffffff         | lea                 eax, [ebp - 0x9c]
            //   50                   | push                eax
            //   56                   | push                esi
            //   8d5de8               | lea                 ebx, [ebp - 0x18]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_1 = { c3 8bce 69c944010000 8d81a05b4100 8b10 c1e204 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   8bce                 | mov                 ecx, esi
            //   69c944010000         | imul                ecx, ecx, 0x144
            //   8d81a05b4100         | lea                 eax, [ecx + 0x415ba0]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   c1e204               | shl                 edx, 4

        $sequence_2 = { b9???????? e8???????? 6a00 50 ff15???????? 8bf0 }
            // n = 6, score = 100
            //   b9????????           |                     
            //   e8????????           |                     
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_3 = { ff7570 56 e8???????? 8b4574 }
            // n = 4, score = 100
            //   ff7570               | push                dword ptr [ebp + 0x70]
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b4574               | mov                 eax, dword ptr [ebp + 0x74]

        $sequence_4 = { 33f6 40 eb1a 81f900000100 }
            // n = 4, score = 100
            //   33f6                 | xor                 esi, esi
            //   40                   | inc                 eax
            //   eb1a                 | jmp                 0x1c
            //   81f900000100         | cmp                 ecx, 0x10000

        $sequence_5 = { e8???????? 99 f77dfc 8bda 837d6806 750b e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   99                   | cdq                 
            //   f77dfc               | idiv                dword ptr [ebp - 4]
            //   8bda                 | mov                 ebx, edx
            //   837d6806             | cmp                 dword ptr [ebp + 0x68], 6
            //   750b                 | jne                 0xd
            //   e8????????           |                     

        $sequence_6 = { 33c0 40 8b4d1c 3bce 7405 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   8b4d1c               | mov                 ecx, dword ptr [ebp + 0x1c]
            //   3bce                 | cmp                 ecx, esi
            //   7405                 | je                  7

        $sequence_7 = { 8bec 83ec2c 56 57 6a02 8bf0 }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec2c               | sub                 esp, 0x2c
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a02                 | push                2
            //   8bf0                 | mov                 esi, eax

        $sequence_8 = { 56 57 7512 0fb64508 6bc014 8bb848044200 897dfc }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   7512                 | jne                 0x14
            //   0fb64508             | movzx               eax, byte ptr [ebp + 8]
            //   6bc014               | imul                eax, eax, 0x14
            //   8bb848044200         | mov                 edi, dword ptr [eax + 0x420448]
            //   897dfc               | mov                 dword ptr [ebp - 4], edi

        $sequence_9 = { 53 53 a3???????? 895c2420 895c2424 895c241c 53 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   a3????????           |                     
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 278528
}